/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.fluid;

import betterwithmods.util.FluidUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockLiquidWrapper
implements IFluidHandler {
    protected final BlockLiquid blockLiquid;
    protected final World world;
    protected final BlockPos blockPos;

    public BlockLiquidWrapper(BlockLiquid blockLiquid, World world, BlockPos blockPos) {
        this.blockLiquid = blockLiquid;
        this.world = world;
        this.blockPos = blockPos;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidStack containedStack = null;
        IBlockState blockState = this.world.func_180495_p(this.blockPos);
        if (blockState.func_177230_c() == this.blockLiquid) {
            containedStack = this.getStack(blockState);
        }
        return new FluidTankProperties[]{new FluidTankProperties(containedStack, 1000, false, true)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.amount < 1000) {
            return 0;
        }
        if (doFill) {
            Material material = this.blockLiquid.func_176223_P().func_185904_a();
            BlockDynamicLiquid block = BlockLiquid.func_176361_a((Material)material);
            if (!this.world.field_72995_K) {
                FluidUtils.setLiquid(this.world, this.blockPos, (Block)block, 2);
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos p2 = this.blockPos.func_177972_a(facing);
                    FluidUtils.setLiquid(this.world, p2, (Block)block, 5);
                }
            }
        }
        return 1000;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack containedStack;
        if (resource == null || resource.amount < 1000) {
            return null;
        }
        IBlockState blockState = this.world.func_180495_p(this.blockPos);
        if (blockState.func_177230_c() == this.blockLiquid && (containedStack = this.getStack(blockState)) != null && resource.containsFluid(containedStack)) {
            return containedStack;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack containedStack;
        IBlockState blockState = this.world.func_180495_p(this.blockPos);
        if (blockState.func_177230_c() == this.blockLiquid && (containedStack = this.getStack(blockState)) != null) {
            if (containedStack.getFluid() == FluidRegistry.LAVA && containedStack.amount <= maxDrain) {
                if (doDrain) {
                    this.world.func_180501_a(this.blockPos, Blocks.field_150350_a.func_176223_P(), 11);
                }
                return null;
            }
            containedStack.amount = maxDrain;
            return containedStack;
        }
        return null;
    }

    @Nullable
    private FluidStack getStack(IBlockState blockState) {
        Material material = blockState.func_185904_a();
        if (material == Material.field_151586_h) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (material == Material.field_151587_i && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }
}

