/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AABBArray
extends AxisAlignedBB {
    private AxisAlignedBB[] boundingBoxes;

    public AABBArray(AxisAlignedBB ... boundingBoxes) {
        this(AABBArray.join(boundingBoxes));
        this.boundingBoxes = boundingBoxes;
        this.boundingBoxes = AABBArray.getParts(this);
    }

    private AABBArray(AxisAlignedBB full) {
        super(full.field_72340_a, full.field_72338_b, full.field_72339_c, full.field_72336_d, full.field_72337_e, full.field_72334_f);
    }

    private static AxisAlignedBB join(AxisAlignedBB[] in) {
        if (in.length == 0) {
            throw new NullPointerException();
        }
        AxisAlignedBB aabb1 = in[0];
        for (int i = 1; i < in.length; ++i) {
            aabb1 = aabb1.func_111270_a(in[i]);
        }
        return aabb1;
    }

    public static AxisAlignedBB[] getParts(AxisAlignedBB source) {
        if (source instanceof AABBArray) {
            HashSet bbs = new HashSet();
            Arrays.asList(((AABBArray)source).boundingBoxes).forEach((? super T aabb) -> bbs.addAll(Arrays.asList(AABBArray.getParts(aabb))));
            return bbs.toArray(new AxisAlignedBB[0]);
        }
        return new AxisAlignedBB[]{source};
    }

    public boolean func_189973_a(Vec3d p_189973_1_, Vec3d p_189973_2_) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            flag |= axisAlignedBB.func_189973_a(p_189973_1_, p_189973_2_);
        }
        return flag;
    }

    public boolean func_186668_a(double x1, double y1, double z1, double x2, double y2, double z2) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.func_186668_a(x1, y1, z1, x2, y2, z2);
        }
        return flag;
    }

    public AABBArray offset(double x, double y, double z) {
        AxisAlignedBB[] parts = AABBArray.getParts(this);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].func_72317_d(x, y, z);
        }
        return new AABBArray(parts);
    }

    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            offsetX = axisAlignedBB.func_72316_a(other, offsetX);
        }
        return offsetX;
    }

    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            offsetY = axisAlignedBB.func_72323_b(other, offsetY);
        }
        return offsetY;
    }

    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            offsetZ = axisAlignedBB.func_72322_c(other, offsetZ);
        }
        return offsetZ;
    }

    public boolean func_72326_a(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            flag |= axisAlignedBB.func_72326_a(other);
        }
        return flag;
    }

    public boolean func_72318_a(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.func_72318_a(vec);
        }
        return flag;
    }

    public boolean func_186669_d(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.func_186669_d(vec);
        }
        return flag;
    }

    public boolean func_186667_c(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.func_186667_c(vec);
        }
        return flag;
    }

    public boolean func_186660_b(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.func_186660_b(vec);
        }
        return flag;
    }

    @Nonnull
    public AABBArray grow(double x, double y, double z) {
        AABBArray aabbArray = new AABBArray(this.boundingBoxes);
        for (int i = 0; i < aabbArray.boundingBoxes.length; ++i) {
            aabbArray.boundingBoxes[i] = aabbArray.boundingBoxes[i].func_72314_b(x, y, z);
        }
        return aabbArray;
    }

    @Nonnull
    public AABBArray grow(double value) {
        return this.grow(value, value, value);
    }

    public RayTraceResult func_72327_a(Vec3d vecA, Vec3d vecB) {
        AxisAlignedBB axisAlignedBB;
        RayTraceResult result = null;
        AxisAlignedBB[] axisAlignedBBArray = AABBArray.getParts(this);
        int n = axisAlignedBBArray.length;
        for (int i = 0; i < n && (result = (axisAlignedBB = axisAlignedBBArray[i]).func_72327_a(vecA, vecB)) == null; ++i) {
        }
        return result;
    }

    public AABBArray forEach(Function<AxisAlignedBB, AxisAlignedBB> consumer) {
        AxisAlignedBB[] var1 = AABBArray.getParts(this);
        for (int i = 0; i < var1.length; ++i) {
            var1[i] = consumer.apply(var1[i]);
        }
        return new AABBArray(var1);
    }

    public AxisAlignedBB func_72321_a(double x, double y, double z) {
        return super.func_72321_a(x, y, z);
    }

    public AxisAlignedBB func_186664_h(double value) {
        return super.func_186664_h(value);
    }

    public AxisAlignedBB func_186670_a(BlockPos pos) {
        return super.func_186670_a(pos);
    }

    public AxisAlignedBB func_186666_e(double y2) {
        return super.func_186666_e(y2);
    }

    public AxisAlignedBB func_111270_a(AxisAlignedBB other) {
        return super.func_111270_a(other);
    }

    public AxisAlignedBB[] getBoundingBoxes() {
        return this.boundingBoxes;
    }
}

