/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWMItems;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Feature;
import betterwithmods.util.EntityUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CreeperShearing
extends Feature {
    public static Set<ResourceLocation> CREEPERS;

    @Override
    public void setupConfig() {
        CREEPERS = ConfigHelper.loadPropRLSet("Creepers", "List of valid creepers", this.configCategory, new String[]{"minecraft:creeper"});
    }

    private boolean isMatching(EntityLivingBase entity) {
        return CREEPERS.stream().anyMatch(r -> EntityList.func_180123_a((Entity)entity, (ResourceLocation)r));
    }

    @SubscribeEvent
    public void mobDrops(LivingDropsEvent event) {
        double chance;
        EntityLivingBase entity = event.getEntityLiving();
        if (this.isMatching(entity) && (chance = entity.func_70681_au().nextDouble() + 0.1 * (double)event.getLootingLevel()) <= 0.05) {
            WorldUtils.addDrop(event, new ItemStack(BWMItems.CREEPER_OYSTER));
        }
    }

    @SubscribeEvent
    public void shearCreeper(PlayerInteractEvent.EntityInteractSpecific e) {
        Item item;
        EntityLivingBase creeper;
        if (e.getTarget() instanceof EntityLivingBase && this.isMatching(creeper = (EntityLivingBase)e.getTarget()) && e.getSide().isServer() && creeper.func_70089_S() && !e.getItemStack().func_190926_b() && ((item = e.getItemStack().func_77973_b()) instanceof ItemShears || item.getHarvestLevel(e.getItemStack(), "shear", e.getEntityPlayer(), null) > 0)) {
            if (e.getEntityPlayer().func_184811_cZ().func_185141_a(item)) {
                return;
            }
            e.getEntityPlayer().func_184811_cZ().func_185145_a(item, 20);
            e.getItemStack().func_77972_a(1, e.getEntityLiving());
            InvUtils.ejectStack(e.getWorld(), creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, new ItemStack(BWMItems.CREEPER_OYSTER));
            EntityShearedCreeper shearedCreeper = new EntityShearedCreeper(e.getWorld());
            creeper.func_70097_a(new DamageSource(""), 0.0f);
            EntityUtils.copyEntityInfo(creeper, (EntityLivingBase)shearedCreeper);
            e.getWorld().func_184148_a(null, shearedCreeper.field_70165_t, shearedCreeper.field_70163_u, shearedCreeper.field_70161_v, SoundEvents.field_187882_fq, SoundCategory.HOSTILE, 1.0f, 0.3f);
            e.getWorld().func_184148_a(null, shearedCreeper.field_70165_t, shearedCreeper.field_70163_u, shearedCreeper.field_70161_v, SoundEvents.field_187763_eJ, SoundCategory.HOSTILE, 1.0f, 1.0f);
            creeper.func_70106_y();
            e.getWorld().func_72838_d((Entity)shearedCreeper);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Shearing a Creeper will removes its ability to explode, making him very sad";
    }
}

