/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures.chicken;

import betterwithmods.common.entity.EntityIngredientRelation;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.creatures.chicken.EggLayer;
import betterwithmods.util.WorldUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreIngredient;

public class HCChickens
extends Feature {
    public static final ResourceLocation EGG_LAYER = new ResourceLocation("betterwithmods", "egglayer");
    public static Ingredient SEEDS = new OreIngredient("seed");

    @Nullable
    public static EggLayer getLayer(@Nonnull Entity entity) {
        return (EggLayer)entity.getCapability(EggLayer.EGG_LAYER_CAP, EnumFacing.DOWN);
    }

    @Override
    public void setupConfig() {
    }

    @Override
    public String getFeatureDescription() {
        return "Rework chicken breeding. Chickens don't breed in pairs. You feed a single chicken 1 seed, and it craps out an egg that can be thrown. The egg either makes a chicken, or drops raw egg.";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(EggLayer.class, (Capability.IStorage)new EggLayer.CapabilityEggLayer(), EggLayer::new);
    }

    @SubscribeEvent
    public void onAttachCap(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityChicken) {
            event.addCapability(EGG_LAYER, (ICapabilityProvider)new EggLayer(new ItemStack(Items.field_151110_aK), SEEDS));
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EggLayer layer;
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (entityLiving instanceof EntityChicken) {
            EntityChicken chicken = (EntityChicken)entityLiving;
            chicken.field_70887_j = 6000000;
        }
        if (entityLiving.hasCapability(EggLayer.EGG_LAYER_CAP, EnumFacing.DOWN) && (layer = HCChickens.getLayer((Entity)entityLiving)) != null && layer.isFeed()) {
            layer.setTicks(layer.getTicks() - 1);
            if (WorldUtils.isTimeFrame(entityLiving.field_70170_p, WorldUtils.TimeFrame.DAWN) && layer.canLayEgg()) {
                layer.lay(entityLiving);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EggLayer layer;
        if (SEEDS.apply(event.getItemStack()) && event.getTarget() instanceof EntityLiving && (layer = HCChickens.getLayer(event.getTarget())) != null) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            layer.feed((EntityLiving)event.getTarget(), event.getItemStack());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static class LayerIngredientRelation
    implements EntityIngredientRelation {
        @Override
        public ResourceLocation getName() {
            return EGG_LAYER;
        }

        @Override
        public Ingredient getIngredient(Entity entity) {
            EggLayer layer = HCChickens.getLayer(entity);
            if (layer != null) {
                return layer.getFeedItems();
            }
            return null;
        }
    }
}

