/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.hardcore.needs.HCNames;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerDataHandler
extends Feature {
    private static final ResourceLocation PLAYER_INFO = new ResourceLocation("betterwithmods", "player_info");
    @CapabilityInject(value=PlayerInfo.class)
    public static Capability<PlayerInfo> CAP_PLAYER_INFO = null;
    public static final String TEAM = "BWMTeam";

    public PlayerDataHandler() {
        this.canDisable = false;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(PlayerInfo.class, (Capability.IStorage)new CapabilityPlayerInfo(), PlayerInfo::new);
    }

    @SubscribeEvent
    public void clone(PlayerEvent.Clone event) {
        PlayerInfo o = PlayerDataHandler.getPlayerInfo(event.getOriginal());
        PlayerInfo n = PlayerDataHandler.getPlayerInfo(event.getEntityPlayer());
        if (o != null && n != null) {
            n.deserializeNBT(o.serializeNBT());
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !event.getCapabilities().containsKey(PLAYER_INFO)) {
            event.addCapability(PLAYER_INFO, (ICapabilityProvider)new PlayerInfo());
        }
    }

    public static PlayerInfo getPlayerInfo(EntityPlayer player) {
        if (player != null && player.hasCapability(CAP_PLAYER_INFO, null)) {
            return (PlayerInfo)player.getCapability(CAP_PLAYER_INFO, null);
        }
        return null;
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        Scoreboard scoreboard = event.getServer().func_130014_f_().func_96441_U();
        if (scoreboard.func_96508_e(TEAM) == null) {
            scoreboard.func_96527_f(TEAM);
        }
        scoreboard.func_96508_e(TEAM).func_178772_a(ModuleLoader.isFeatureEnabled(HCNames.class) ? Team.EnumVisible.NEVER : Team.EnumVisible.ALWAYS);
    }

    public static class PlayerInfo
    implements ICapabilitySerializable<NBTTagCompound> {
        public boolean givenManual;
        private int ticksSinceDeath;

        public int getTicksSinceDeath() {
            return this.ticksSinceDeath;
        }

        public void setTicksSinceDeath(int ticks) {
            this.ticksSinceDeath = ticks;
        }

        public void incrementTicksSinceDeath(int i) {
            this.ticksSinceDeath += i;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAP_PLAYER_INFO;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CAP_PLAYER_INFO) {
                return (T)CAP_PLAYER_INFO.cast((Object)this);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("givenManual", this.givenManual);
            tag.func_74768_a("ticksSinceDeath", this.ticksSinceDeath);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.givenManual = nbt.func_74767_n("givenManual");
            this.ticksSinceDeath = nbt.func_74762_e("ticksSinceDeath");
        }
    }

    public static class CapabilityPlayerInfo
    implements Capability.IStorage<PlayerInfo> {
        @Nullable
        public NBTBase writeNBT(Capability<PlayerInfo> capability, PlayerInfo instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<PlayerInfo> capability, PlayerInfo instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

