/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.api.recipe.impl.ChanceOutput;
import betterwithmods.api.recipe.impl.ListOutputs;
import betterwithmods.api.recipe.impl.WeightedOutputs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.HopperFilter;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.common.registry.SoulsandFilter;
import betterwithmods.common.registry.block.recipe.IngredientSpecial;
import betterwithmods.module.Feature;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreIngredient;

public class HopperRecipes
extends Feature {
    public static boolean brimstoneFiltering;
    public static boolean useSelfFiltering;

    public HopperRecipes() {
        this.canDisable = false;
    }

    @Override
    public void setupConfig() {
        brimstoneFiltering = this.loadPropBool("Glowstone Filtering", "Passing glowstone through a soulsand filter makes brimstone.", false);
        useSelfFiltering = this.loadPropBool("Self Filtering", "Allow the Hopper to filter by the item in the filter slot.", false);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BWRegistry.HOPPER_FILTERS.addFilter(new HopperFilter("betterwithmods:ladder", StackIngredient.fromStacks(new ItemStack(Blocks.field_150468_ap)), Lists.newArrayList((Object[])new Ingredient[]{new IngredientSpecial(stack -> !(stack.func_77973_b() instanceof ItemBlock)), new OreIngredient("treeSapling")})));
        BWRegistry.HOPPER_FILTERS.addFilter(new SoulsandFilter(StackIngredient.fromStacks(new ItemStack(Blocks.field_150425_aM)), Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(new ItemStack(Blocks.field_150425_aM))})));
        BWRegistry.HOPPER_FILTERS.addFilter(new HopperFilter("betterwithmods:wicker", StackIngredient.fromStacks(new ItemStack(BWMBlocks.WICKER)), Lists.newArrayList((Object[])new Ingredient[]{new OreIngredient("sand"), new OreIngredient("listAllseeds"), new OreIngredient("foodFlour"), new OreIngredient("pile"), new IngredientSpecial(stack -> BWOreDictionary.dustNames.stream().anyMatch(ore -> ore.apply(stack)))})));
        BWRegistry.HOPPER_FILTERS.addFilter(new HopperFilter("betterwithmods:trapdoor", StackIngredient.fromStacks(new ItemStack(Blocks.field_150415_aT)), Lists.newArrayList((Object[])new Ingredient[]{new IngredientSpecial(stack -> stack.func_77973_b() instanceof ItemBlock)})));
        BWRegistry.HOPPER_FILTERS.addFilter(new HopperFilter("betterwithmods:grates", (Ingredient)new OreIngredient("grates"), Lists.newArrayList((Object[])new Ingredient[]{new IngredientSpecial(stack -> stack.func_77976_d() == 1)})));
        BWRegistry.HOPPER_FILTERS.addFilter(new HopperFilter("betterwithmods:iron_bar", StackIngredient.fromStacks(new ItemStack(Blocks.field_150411_aY)), Lists.newArrayList((Object[])new Ingredient[]{new IngredientSpecial(stack -> stack.func_77976_d() > 1)})));
        BWRegistry.HOPPER_FILTERS.addFilter(new HopperFilter("betterwithmods:slats", (Ingredient)new OreIngredient("slats"), BWOreDictionary.fromOres("paper", "scroll", "string", "fiberHemp", "hideTanned", "hideTanned", "hideBelt", "hideScoured", "hideStrap", "leather", "wool")));
        HopperInteractions.addHopperRecipe(new HopperInteractions.SoulUrnRecipe((Ingredient)new OreIngredient("dustNetherrack"), ItemStack.field_190927_a, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST)));
        HopperInteractions.addHopperRecipe(new HopperInteractions.SoulUrnRecipe((Ingredient)new OreIngredient("dustSoul"), ItemStack.field_190927_a, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST)));
        if (brimstoneFiltering) {
            HopperInteractions.addHopperRecipe(new HopperInteractions.SoulUrnRecipe((Ingredient)new OreIngredient("dustGlowstone"), ItemStack.field_190927_a, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE)));
        }
        HopperInteractions.addHopperRecipe(new HopperInteractions.HopperRecipe("betterwithmods:wicker", (Ingredient)StackIngredient.fromStacks(new ItemStack(Blocks.field_150351_n)), new WeightedOutputs(new ChanceOutput(new ItemStack((Block)Blocks.field_150354_m), 0.5), new ChanceOutput(new ItemStack((Block)Blocks.field_150354_m, 1, 1), 0.5)), new ListOutputs(new ItemStack(Items.field_151145_ak))));
        HopperInteractions.addHopperRecipe(new HopperInteractions.HopperRecipe("betterwithmods:soul_sand", (Ingredient)new OreIngredient("sand"), ItemStack.field_190927_a, new ItemStack[]{new ItemStack(Blocks.field_150425_aM)}){

            @Override
            public boolean canCraft(World world, BlockPos pos) {
                TileEntityFilteredHopper hopper = (TileEntityFilteredHopper)world.func_175625_s(pos);
                assert (hopper != null);
                return super.canCraft(world, pos) && hopper.soulsRetained > 0;
            }

            @Override
            public void onCraft(World world, BlockPos pos, EntityItem item, TileEntityFilteredHopper tile) {
                TileEntityFilteredHopper hopper = (TileEntityFilteredHopper)world.func_175625_s(pos);
                if (hopper != null) {
                    hopper.decreaseSoulCount(1);
                }
                super.onCraft(world, pos, item, tile);
            }
        });
    }
}

