/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.manual.segment.render;

import betterwithmods.manual.api.manual.ImageRenderer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TextureImageRenderer
implements ImageRenderer {
    private final ResourceLocation location;
    private final ImageTexture texture;

    public TextureImageRenderer(ResourceLocation location) {
        this.location = location;
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject image = manager.func_110581_b(location);
        if (image instanceof ImageTexture) {
            this.texture = (ImageTexture)image;
        } else {
            if (image != null && image.func_110552_b() != -1) {
                TextureUtil.func_147942_a((int)image.func_110552_b());
            }
            this.texture = new ImageTexture(location);
            manager.func_110579_a(location, (ITextureObject)this.texture);
        }
    }

    @Override
    public int getWidth() {
        return this.texture.width;
    }

    @Override
    public int getHeight() {
        return this.texture.height;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.location);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)this.texture.height);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)this.texture.width, (float)this.texture.height);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)this.texture.width, (float)0.0f);
        GL11.glEnd();
    }

    private static class ImageTexture
    extends AbstractTexture {
        private final ResourceLocation location;
        private int width = 0;
        private int height = 0;

        public ImageTexture(ResourceLocation location) {
            this.location = location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_110551_a(IResourceManager manager) throws IOException {
            this.func_147631_c();
            try (InputStream is = null;){
                IResource resource = manager.func_110536_a(this.location);
                is = resource.func_110527_b();
                BufferedImage bi = ImageIO.read(is);
                TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)bi, (boolean)false, (boolean)false);
                this.width = bi.getWidth();
                this.height = bi.getHeight();
            }
        }
    }
}

