/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.world;

import betterwithmods.module.tweaks.MineshaftGeneration;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureMineshaftPieces;

public class BWStructureMineshaftPieces {
    private static StructureMineshaftPieces.Peice createRandomShaftPiece(List<StructureComponent> structureComponents, Random random, int x, int y, int z, @Nullable EnumFacing facing, int componentType, MapGenMineshaft.Type type) {
        int i = random.nextInt(100);
        if (i >= 80) {
            StructureBoundingBox structureboundingbox = Cross.func_175813_a(structureComponents, (Random)random, (int)x, (int)y, (int)z, (EnumFacing)facing);
            if (structureboundingbox != null) {
                return new Cross(componentType, random, structureboundingbox, facing, type);
            }
        } else if (i >= 70) {
            StructureBoundingBox structureboundingbox1 = Stairs.func_175812_a(structureComponents, (Random)random, (int)x, (int)y, (int)z, (EnumFacing)facing);
            if (structureboundingbox1 != null) {
                return new Stairs(componentType, random, structureboundingbox1, facing, type);
            }
        } else {
            StructureBoundingBox structureboundingbox2 = Corridor.func_175814_a(structureComponents, (Random)random, (int)x, (int)y, (int)z, (EnumFacing)facing);
            if (structureboundingbox2 != null) {
                return new Corridor(componentType, random, structureboundingbox2, facing, type);
            }
        }
        return null;
    }

    private static StructureMineshaftPieces.Peice generateAndAddPiece(StructureComponent component, List<StructureComponent> structureComponents, Random random, int x, int y, int z, EnumFacing facing, int componentType) {
        if (componentType > 8) {
            return null;
        }
        if (Math.abs(x - component.func_74874_b().field_78897_a) <= 80 && Math.abs(z - component.func_74874_b().field_78896_c) <= 80) {
            MapGenMineshaft.Type type = ((StructureMineshaftPieces.Peice)component).field_189920_a;
            StructureMineshaftPieces.Peice piece = BWStructureMineshaftPieces.createRandomShaftPiece(structureComponents, random, x, y, z, facing, componentType + 1, type);
            if (piece != null) {
                structureComponents.add((StructureComponent)piece);
                piece.func_74861_a(component, structureComponents, random);
            }
            return piece;
        }
        return null;
    }

    public static class Stairs
    extends StructureMineshaftPieces.Stairs {
        public Stairs() {
        }

        public Stairs(int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing facing, MapGenMineshaft.Type type) {
            super(componentType, random, boundingBox, facing, type);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            int i = this.func_74877_c();
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                        break;
                    }
                    case EAST: {
                        BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                    }
                }
            }
        }
    }

    public static class Room
    extends StructureMineshaftPieces.Room {
        public Room() {
        }

        public Room(int componentType, Random random, int chunkX, int chunkZ, MapGenMineshaft.Type type) {
            super(componentType, random, chunkX, chunkZ, type);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            StructureBoundingBox boundingBox;
            StructureMineshaftPieces.Peice piece;
            int k;
            int i = this.func_74877_c();
            int j = this.field_74887_e.func_78882_c() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                piece = BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.field_74949_a.add(new StructureBoundingBox(boundingBox.field_78897_a, boundingBox.field_78895_b, this.field_74887_e.field_78896_c, boundingBox.field_78893_d, boundingBox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                piece = BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.field_74949_a.add(new StructureBoundingBox(boundingBox.field_78897_a, boundingBox.field_78895_b, this.field_74887_e.field_78892_f - 1, boundingBox.field_78893_d, boundingBox.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                piece = BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, EnumFacing.WEST, i);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.field_74949_a.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, boundingBox.field_78895_b, boundingBox.field_78896_c, this.field_74887_e.field_78897_a + 1, boundingBox.field_78894_e, boundingBox.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                StructureMineshaftPieces.Peice structurecomponent = BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, EnumFacing.EAST, i);
                if (structurecomponent == null) continue;
                boundingBox = structurecomponent.func_74874_b();
                this.field_74949_a.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, boundingBox.field_78895_b, boundingBox.field_78896_c, this.field_74887_e.field_78893_d, boundingBox.field_78894_e, boundingBox.field_78892_f));
            }
        }

        protected IBlockState getFloorBlock() {
            return MineshaftGeneration.roomFloor.getBlockState((StructureMineshaftPieces.Peice)this);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            boolean success = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn);
            if (success) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, this.getFloorBlock(), Blocks.field_150350_a.func_176223_P(), true);
            }
            return success;
        }
    }

    public static class Cross
    extends StructureMineshaftPieces.Cross {
        public Cross() {
        }

        public Cross(int componentType, Random random, StructureBoundingBox boundingBox, @Nullable EnumFacing facing, MapGenMineshaft.Type type) {
            super(componentType, random, boundingBox, facing, type);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            int i = this.func_74877_c();
            switch (this.field_74953_a) {
                default: {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case SOUTH: {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case WEST: {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    break;
                }
                case EAST: {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
            }
            if (this.field_74952_b) {
                if (rand.nextBoolean()) {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                }
                if (rand.nextBoolean()) {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
                if (rand.nextBoolean()) {
                    BWStructureMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                }
            }
        }

        protected IBlockState func_189919_b() {
            return MineshaftGeneration.supports.getBlockState((StructureMineshaftPieces.Peice)this);
        }

        protected IBlockState func_189917_F_() {
            return MineshaftGeneration.planks.getBlockState((StructureMineshaftPieces.Peice)this);
        }
    }

    public static class Corridor
    extends StructureMineshaftPieces.Corridor {
        public Corridor() {
        }

        public Corridor(int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing facing, MapGenMineshaft.Type type) {
            super(componentType, random, boundingBox, facing, type);
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> structureComponents, Random rand) {
            block24: {
                int componentType = this.func_74877_c();
                int size = rand.nextInt(4);
                EnumFacing enumfacing = this.func_186165_e();
                if (enumfacing != null) {
                    switch (enumfacing) {
                        default: {
                            if (size <= 1) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, enumfacing, componentType);
                                break;
                            }
                            if (size == 2) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.WEST, componentType);
                                break;
                            }
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.EAST, componentType);
                            break;
                        }
                        case SOUTH: {
                            if (size <= 1) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, enumfacing, componentType);
                                break;
                            }
                            if (size == 2) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.WEST, componentType);
                                break;
                            }
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.EAST, componentType);
                            break;
                        }
                        case WEST: {
                            if (size <= 1) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, componentType);
                                break;
                            }
                            if (size == 2) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, componentType);
                                break;
                            }
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, componentType);
                            break;
                        }
                        case EAST: {
                            if (size <= 1) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, componentType);
                                break;
                            }
                            if (size == 2) {
                                BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, componentType);
                                break;
                            }
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, componentType);
                        }
                    }
                }
                if (componentType >= 8) break block24;
                if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, componentType + 1);
                        } else if (j1 == 1) {
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, componentType + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, EnumFacing.WEST, componentType + 1);
                        } else if (l == 1) {
                            BWStructureMineshaftPieces.generateAndAddPiece(component, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, EnumFacing.EAST, componentType + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected IBlockState func_189919_b() {
            return MineshaftGeneration.supports.getBlockState((StructureMineshaftPieces.Peice)this);
        }

        protected IBlockState func_189917_F_() {
            return MineshaftGeneration.planks.getBlockState((StructureMineshaftPieces.Peice)this);
        }

        protected IBlockState getRailBlock() {
            return MineshaftGeneration.rail.getBlockState((StructureMineshaftPieces.Peice)this);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            boolean success = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn);
            if (success && this.field_74958_a) {
                IBlockState rail = this.getRailBlock();
                for (int i = 0; i <= this.field_74955_d * 5 - 1; ++i) {
                    IBlockState railBlock = this.func_175807_a(worldIn, 1, 0, i, structureBoundingBoxIn);
                    if (!(railBlock.func_177230_c() instanceof BlockRailBase)) continue;
                    float skyBrightness = this.func_189916_b(worldIn, 1, 0, i, structureBoundingBoxIn) > 8 ? 0.9f : 0.7f;
                    this.func_175809_a(worldIn, structureBoundingBoxIn, randomIn, skyBrightness, 1, 0, i, rail);
                }
            }
            return success;
        }
    }
}

