/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.recipes;

import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.recipe.impl.ListOutputs;
import betterwithmods.common.registry.bulk.recipes.BulkCraftEvent;
import betterwithmods.util.InvUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BulkRecipe
implements Comparable<BulkRecipe> {
    protected NonNullList<Ingredient> inputs;
    protected IRecipeOutputs recipeOutput;
    protected int priority;

    public BulkRecipe(List<Ingredient> inputs, IRecipeOutputs outputs, int priority) {
        this.inputs = InvUtils.asNonnullList(inputs);
        this.recipeOutput = outputs;
        this.priority = priority;
    }

    public BulkRecipe(@Nonnull List<Ingredient> inputs, @Nonnull List<ItemStack> outputs) {
        this(inputs, outputs, 0);
    }

    public BulkRecipe(List<Ingredient> inputs, IRecipeOutputs outputs) {
        this.inputs = InvUtils.asNonnullList(inputs);
        this.recipeOutput = outputs;
    }

    public BulkRecipe(List<Ingredient> inputs, @Nonnull List<ItemStack> outputs, int priority) {
        this(inputs, new ListOutputs(outputs), priority);
    }

    public NonNullList<ItemStack> onCraft(World world, TileEntity tile, ItemStackHandler inv) {
        NonNullList items = NonNullList.func_191196_a();
        if (this.consumeIngredients(inv, (NonNullList<ItemStack>)items)) {
            items.addAll(this.getOutputs());
            return BulkCraftEvent.fireOnCraft(tile, world, inv, this, (NonNullList<ItemStack>)items);
        }
        return NonNullList.func_191196_a();
    }

    public IRecipeOutputs getRecipeOutput() {
        return this.recipeOutput;
    }

    public List<ItemStack> getOutputs() {
        return this.recipeOutput.getOutputs();
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    protected boolean consumeIngredients(ItemStackHandler inventory, NonNullList<ItemStack> containItems) {
        HashSet<Ingredient> toConsume = new HashSet<Ingredient>((Collection<Ingredient>)this.inputs);
        for (Ingredient ingredient : toConsume) {
            if (InvUtils.consumeItemsInInventory((IItemHandler)inventory, ingredient, false, containItems)) continue;
            return false;
        }
        return true;
    }

    public boolean isInvalid() {
        return this.getInputs().isEmpty() || this.getInputs().stream().noneMatch(InvUtils::isIngredientValid) || this.recipeOutput.isInvalid();
    }

    public String toString() {
        return String.format("%s: %s -> %s", this.getClass().getSimpleName(), this.inputs, this.recipeOutput);
    }

    public int getPriority() {
        return this.priority;
    }

    public BulkRecipe setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public int compareTo(@Nonnull BulkRecipe bulkRecipe) {
        return Comparator.comparingInt(BulkRecipe::getPriority).reversed().compare(this, bulkRecipe);
    }

    public int matches(ItemStackHandler inventory) {
        int index = Integer.MAX_VALUE;
        for (Ingredient ingredient : this.inputs) {
            if ((index = Math.min(index, InvUtils.getFirstOccupiedStackOfItem((IItemHandler)inventory, ingredient))) != -1) continue;
            return -1;
        }
        return index;
    }

    public boolean isHidden() {
        return false;
    }
}

