/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.block.recipe;

import betterwithmods.common.BWMRecipes;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockIngredient
extends Ingredient {
    private NonNullList<ItemStack> stacks;
    private IntList itemIds = null;
    private ItemStack[] array = null;
    private int lastSizeA = -1;
    private int lastSizeL = -1;
    private Set<IBlockState> states;

    public BlockIngredient(String ore) {
        super(0);
        this.stacks = OreDictionary.getOres((String)ore);
    }

    public BlockIngredient(List<ItemStack> stacks) {
        super(0);
        this.stacks = InvUtils.asNonnullList(stacks);
    }

    public BlockIngredient(ItemStack ... stacks) {
        super(0);
        this.stacks = InvUtils.asNonnullList(stacks);
    }

    public BlockIngredient(Ingredient ingredient) {
        super(0);
        this.stacks = InvUtils.asNonnullList(ingredient.func_193365_a());
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.array == null || this.lastSizeA != this.stacks.size()) {
            if (this.states == null) {
                this.states = Sets.newHashSet();
            }
            NonNullList lst = NonNullList.func_191196_a();
            Iterator iter = this.stacks.iterator();
            while (iter.hasNext()) {
                ItemStack itemstack = (ItemStack)iter.next();
                Set<IBlockState> s = BWMRecipes.getStatesFromStack(itemstack);
                if (s.isEmpty()) {
                    iter.remove();
                    continue;
                }
                this.states.addAll(s);
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    continue;
                }
                lst.add((Object)itemstack);
            }
            this.array = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
            this.lastSizeA = this.stacks.size();
        }
        return this.array;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.itemIds == null || this.lastSizeL != this.stacks.size()) {
            this.itemIds = new IntArrayList(this.stacks.size());
            for (ItemStack itemstack : this.stacks) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList lst = NonNullList.func_191196_a();
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    for (ItemStack item : lst) {
                        this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)item));
                    }
                    continue;
                }
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
            this.lastSizeL = this.stacks.size();
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        return input != null && this.stacks.stream().anyMatch(t -> InvUtils.matches(t, input));
    }

    public boolean apply(World world, BlockPos pos, @Nullable IBlockState state) {
        return state != null && this.getStates().contains(state);
    }

    protected void invalidate() {
        this.itemIds = null;
        this.array = null;
    }

    public boolean isSimple() {
        return true;
    }

    public Set<IBlockState> getStates() {
        if (this.states == null) {
            this.func_193365_a();
        }
        return this.states;
    }
}

