/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.AABBArray;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Mod.EventBusSubscriber(modid="betterwithmods")
public class EntityExtendingRope
extends Entity
implements IEntityAdditionalSpawnData {
    public AABBArray blockBB;
    private BlockPos pulley;
    private int targetY;
    private boolean up;
    private Map<Vec3i, IBlockState> blocks;
    private Map<Vec3i, NBTTagCompound> tiles;
    private float speed = 0.12f;

    public EntityExtendingRope(World worldIn) {
        this(worldIn, null, null, 0);
    }

    public EntityExtendingRope(World worldIn, BlockPos pulley, BlockPos source, int targetY) {
        super(worldIn);
        this.pulley = pulley;
        this.targetY = targetY;
        if (source != null) {
            this.up = source.func_177956_o() < targetY;
            this.func_70107_b((double)source.func_177958_n() + 0.5, source.func_177956_o(), (double)source.func_177952_p() + 0.5);
        }
        this.blocks = Maps.newHashMap();
        this.tiles = Maps.newHashMap();
        this.blockBB = null;
        this.func_70105_a(0.1f, 1.0f);
        this.field_70158_ak = true;
    }

    public void func_70107_b(double x, double y, double z) {
        double pY = this.field_70163_u;
        super.func_70107_b(x, y, z);
        if (this.blocks != null) {
            this.updatePassengers(pY, this.field_70163_u, false);
        }
    }

    protected void func_70088_a() {
    }

    public float func_70047_e() {
        return -1.0f;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.pulley = new BlockPos(compound.func_74762_e("PulleyX"), compound.func_74762_e("PulleyY"), compound.func_74762_e("PulleyZ"));
        this.targetY = compound.func_74762_e("TargetY");
        this.up = compound.func_74767_n("Up");
        if (compound.func_74764_b("BlockData")) {
            byte[] bytes = compound.func_74770_j("BlockData");
            ByteBuf buf = Unpooled.buffer((int)bytes.length);
            buf.writeBytes(bytes);
            this.blocks = this.deserializeBlockmap(buf);
        }
        if (compound.func_74764_b("Tiles")) {
            this.tiles = this.deserializeTiles(compound.func_74775_l("Tiles"));
        }
        this.rebuildBlockBoundingBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("PulleyX", this.pulley.func_177958_n());
        compound.func_74768_a("PulleyY", this.pulley.func_177956_o());
        compound.func_74768_a("PulleyZ", this.pulley.func_177952_p());
        compound.func_74768_a("TargetY", this.targetY);
        compound.func_74757_a("Up", this.up);
        ByteBuf buf = Unpooled.buffer();
        this.serializeBlockmap(buf, this.blocks);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        compound.func_74773_a("BlockData", bytes);
        NBTTagCompound t = new NBTTagCompound();
        this.serializeTiles(t, this.tiles);
        compound.func_74782_a("Tiles", (NBTBase)t);
        if (GlobalConfig.debug) {
            for (int i = 0; i < bytes.length; ++i) {
                if (i % 16 == 0) {
                    StringBuilder text = new StringBuilder(Integer.toHexString(i));
                    while (text.length() < 8) {
                        text.insert(0, "0");
                    }
                    System.out.print("\n" + text + ": ");
                }
                StringBuilder b = new StringBuilder(Integer.toHexString(Byte.toUnsignedInt(bytes[i])));
                while (b.length() < 2) {
                    b.insert(0, "0");
                }
                System.out.print(b);
                if (i % 2 != 1) continue;
                System.out.print(' ');
            }
        }
    }

    private void serializeTiles(NBTTagCompound tag, Map<Vec3i, NBTTagCompound> tiles) {
        NBTTagList list = new NBTTagList();
        tiles.forEach((vec, tile) -> {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74772_a("offset", new BlockPos(vec).func_177986_g());
            entry.func_74782_a("tile", (NBTBase)tile);
            list.func_74742_a((NBTBase)entry);
        });
        tag.func_74782_a("entries", (NBTBase)list);
    }

    private Map<Vec3i, NBTTagCompound> deserializeTiles(NBTTagCompound tag) {
        HashMap<Vec3i, NBTTagCompound> map = new HashMap<Vec3i, NBTTagCompound>();
        NBTTagList list = tag.func_150295_c("entries", 10);
        list.iterator().forEachRemaining(e -> {
            NBTTagCompound entry = (NBTTagCompound)e;
            BlockPos offset = BlockPos.func_177969_a((long)entry.func_74763_f("offset"));
            NBTTagCompound tileData = entry.func_74775_l("tile");
            map.put((Vec3i)offset, tileData);
        });
        return map;
    }

    private void serializeBlockmap(ByteBuf buf, Map<Vec3i, IBlockState> blocks) {
        buf.writeInt(blocks.size());
        for (Vec3i vec : blocks.keySet()) {
            IBlockState state = blocks.get(vec);
            if (state == null) continue;
            buf.writeInt(vec.func_177958_n());
            buf.writeInt(vec.func_177956_o());
            buf.writeInt(vec.func_177952_p());
            Block block = state.func_177230_c();
            ResourceLocation resourcelocation = state.func_177230_c().getRegistryName();
            if (resourcelocation == null) continue;
            String blockName = resourcelocation.toString();
            buf.writeInt(blockName.length());
            buf.writeBytes(blockName.getBytes(Charset.forName("UTF-8")));
            buf.writeByte((int)((byte)block.func_176201_c(state)));
        }
    }

    private Map<Vec3i, IBlockState> deserializeBlockmap(ByteBuf buf) {
        HashMap<Vec3i, IBlockState> map = new HashMap<Vec3i, IBlockState>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Vec3i vec = new Vec3i(buf.readInt(), buf.readInt(), buf.readInt());
            int len = buf.readInt();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes);
            String name = new String(bytes, Charset.forName("UTF-8"));
            byte meta = buf.readByte();
            IBlockState state = Block.func_149684_b((String)name).func_176203_a((int)meta);
            map.put(vec, state);
        }
        return map;
    }

    private void rebuildBlockBoundingBox() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            this.blockBB = null;
        } else {
            ArrayList<AxisAlignedBB> bbs = new ArrayList<AxisAlignedBB>();
            bbs.add(new AxisAlignedBB(0.45, 0.0, 0.45, 0.55, 1.0, 0.55));
            for (Vec3i vec : this.blocks.keySet()) {
                IBlockState state = this.blocks.get(vec);
                if (!state.func_177230_c().func_149703_v()) continue;
                AxisAlignedBB bb2 = new AxisAlignedBB((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p(), (double)(vec.func_177958_n() + 1), (double)vec.func_177956_o() + this.getBlockStateHeight(state), (double)(vec.func_177952_p() + 1));
                bbs.add(bb2);
            }
            this.blockBB = new AABBArray(bbs.toArray(new AxisAlignedBB[0])).offset(-0.5, 0.0, -0.5);
        }
    }

    private double getSpeed() {
        return this.up ? (double)this.speed : (double)(-this.speed);
    }

    public void func_70071_h_() {
        if (this.up ? this.field_70163_u > (double)this.targetY && this.done() : this.field_70163_u < (double)this.targetY && this.done()) {
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70107_b((double)this.pulley.func_177958_n() + 0.5, this.field_70163_u + this.getSpeed(), (double)this.pulley.func_177952_p() + 0.5);
        this.field_70170_p.func_72866_a((Entity)this, false);
    }

    public void updatePassengers(double posY, double newPosY, boolean b) {
        if (this.blockBB == null || this.field_70170_p == null) {
            return;
        }
        AABBArray oldBB = this.blockBB.offset(this.field_70165_t, posY, this.field_70161_v);
        AABBArray newBB = this.blockBB.offset(this.field_70165_t, newPosY, this.field_70161_v);
        HashSet passengers = Sets.newHashSet((Iterable)this.func_130014_f_().func_175647_a(Entity.class, (AxisAlignedBB)newBB, e -> !(e instanceof EntityExtendingRope)));
        for (Entity e2 : passengers) {
            double yoff;
            AxisAlignedBB ebb = e2.func_174813_aQ();
            if (!newBB.func_72326_a(ebb) || (yoff = -oldBB.func_72323_b(ebb, posY - newPosY)) == 0.0) continue;
            if (this.func_130014_f_().field_72995_K || !(e2 instanceof EntityPlayer) || b) {
                e2.func_70091_d(null, 0.0, yoff, 0.0);
            }
            e2.field_70181_x = this.up ? 0.0 : (double)(-this.speed);
            e2.field_70160_al = false;
            e2.field_70122_E = true;
            e2.field_70124_G = true;
            e2.field_70132_H = true;
            e2.field_70143_R = 0.0f;
        }
    }

    private double getBlockStateHeight(IBlockState blockState) {
        return blockState == null ? 1.0f : (blockState.func_177230_c() == BWMBlocks.ANCHOR ? 0.375f : (float)(!(blockState.func_177230_c() instanceof BlockRailBase) && !(blockState.func_177230_c() instanceof BlockRedstoneWire) ? 1 : 0));
    }

    public boolean func_90999_ad() {
        return false;
    }

    private void reconstruct() {
        BlockPos pos = this.pulley.func_177979_c(this.pulley.func_177956_o() - this.targetY);
        int retries = 0;
        while (!this.blocks.isEmpty() && retries < 10) {
            ++retries;
            int skipped = 0;
            for (Map.Entry<Vec3i, IBlockState> entry : this.blocks.entrySet()) {
                BlockPos blockPos = pos.func_177971_a(entry.getKey());
                IBlockState state2 = entry.getValue();
                if (state2.func_177230_c().func_176196_c(this.func_130014_f_(), blockPos)) {
                    TileEntity tile;
                    this.func_130014_f_().func_180501_a(blockPos, state2, 3);
                    if (this.tiles.containsKey(entry.getKey()) && (tile = this.func_130014_f_().func_175625_s(blockPos)) != null) {
                        NBTTagCompound tag = this.tiles.get(entry.getKey());
                        tile.func_145839_a(tag);
                        tile.func_174878_a(blockPos);
                    }
                    this.blocks.remove(entry.getKey());
                    this.tiles.remove(entry.getKey());
                    skipped = 0;
                    break;
                }
                ++skipped;
            }
            if (skipped != 0) continue;
            retries = 0;
        }
        if (retries > 0) {
            this.blocks.forEach((vec, state) -> state.func_177230_c().getDrops((IBlockAccess)this.func_130014_f_(), pos, state, 0).forEach(stack -> InvUtils.spawnStack(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, stack, 10)));
        }
        this.updatePassengers(this.field_70163_u, this.field_70163_u + (this.up ? 0.0 : 0.5), true);
    }

    private boolean done() {
        if (!this.func_130014_f_().field_72995_K) {
            TileEntity te = this.func_130014_f_().func_175625_s(this.pulley);
            if (te instanceof TileEntityPulley) {
                TileEntityPulley pulley = (TileEntityPulley)te;
                if (!pulley.onJobCompleted(this.up, this.targetY, this)) {
                    this.reconstruct();
                    return true;
                }
            } else {
                this.reconstruct();
                this.func_70106_y();
                return true;
            }
        }
        return false;
    }

    public void addBlock(Vec3i offset, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        TileEntity tile = world.func_175625_s(pos);
        this.blocks.put(offset, state);
        if (tile != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_189515_b(tag);
            this.tiles.put(offset, tag);
            world.func_175713_t(pos);
        }
        this.rebuildBlockBoundingBox();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.pulley.func_177958_n());
        buffer.writeInt(this.pulley.func_177956_o());
        buffer.writeInt(this.pulley.func_177952_p());
        buffer.writeInt(this.targetY);
        buffer.writeBoolean(this.up);
        this.serializeBlockmap(buffer, this.blocks);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.pulley = new BlockPos(additionalData.readInt(), additionalData.readInt(), additionalData.readInt());
        this.targetY = additionalData.readInt();
        this.up = additionalData.readBoolean();
        this.blocks = this.deserializeBlockmap(additionalData);
    }

    public void setTargetY(int i) {
        this.targetY = i;
    }

    public boolean getUp() {
        return this.up;
    }

    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    public boolean isPathBlocked() {
        HashSet blocked = new HashSet();
        this.blocks.forEach((vec, state) -> {
            if (blocked.isEmpty() && !this.up || state.func_177230_c() != BWMBlocks.ANCHOR) {
                BlockPos pos = this.pulley.func_177979_c(this.pulley.func_177956_o() - this.targetY).func_177971_a(vec);
                pos = this.up ? pos.func_177984_a() : pos.func_177977_b();
                Block b = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                if (b != Blocks.field_150350_a && !b.func_176200_f((IBlockAccess)this.func_130014_f_(), pos)) {
                    blocked.add(pos);
                }
            }
        });
        return !blocked.isEmpty();
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public BlockPos getPulleyPosition() {
        return this.pulley;
    }

    public Map<Vec3i, IBlockState> getBlocks() {
        return this.blocks;
    }

    public Map<Vec3i, NBTTagCompound> getTiles() {
        return this.tiles;
    }

    protected void func_70105_a(float width, float height) {
        if (this.blockBB == null) {
            super.func_70105_a(width, height);
        }
    }

    public void func_174826_a(AxisAlignedBB bb) {
        this.rebuildBlockBoundingBox();
        super.func_174826_a((AxisAlignedBB)(this.blockBB != null ? this.blockBB.offset(this.field_70165_t, this.field_70163_u, this.field_70161_v) : bb));
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ() instanceof AABBArray ? ((AABBArray)this.func_174813_aQ()).forEach(i -> i.func_186666_e(i.field_72337_e - 0.125)) : this.func_174813_aQ();
    }

    @SubscribeEvent
    public static void getCollisionBoxes(GetCollisionBoxesEvent e) {
        if (!(e.getEntity() instanceof EntityPlayer) || !e.getEntity().field_70170_p.field_72995_K) {
            // empty if block
        }
    }
}

