/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.mechanical.BlockAxleGenerator;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.module.gameplay.Gameplay;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileAxleGenerator
extends TileBasic
implements ITickable,
IMechanicalPower {
    protected byte power = 0;
    public byte dyeIndex = 0;
    protected float runningSpeed = 0.4f;
    public float currentRotation = 0.0f;
    public float previousRotation = 0.0f;
    public float waterMod = 1.0f;
    protected boolean isValid;
    protected int tick;

    public abstract void calculatePower();

    public abstract void verifyIntegrity();

    public abstract int getRadius();

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("CurrentRotation")) {
            this.currentRotation = tag.func_74760_g("CurrentRotation");
        }
        if (tag.func_74764_b("RotationSpeed")) {
            this.previousRotation = tag.func_74760_g("RotationSpeed");
        }
        if (tag.func_74764_b("power")) {
            this.power = tag.func_74771_c("power");
        }
        if (tag.func_74764_b("DyeIndex")) {
            this.dyeIndex = tag.func_74771_c("DyeIndex");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74774_a("power", this.power);
        t.func_74776_a("CurrentRotation", this.currentRotation);
        t.func_74776_a("RotationSpeed", this.previousRotation);
        return t;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getPrevRotation() {
        return this.previousRotation;
    }

    public void func_73660_a() {
        ++this.tick;
        if (this.tick % 20 == 0 && this.getBlockWorld().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockAxleGenerator) {
            this.verifyIntegrity();
            this.calculatePower();
        }
        if (this.isValid()) {
            if (this.power != 0) {
                this.previousRotation = (float)this.power * this.runningSpeed * this.waterMod;
                this.currentRotation += (float)(this.power * this.power) * this.runningSpeed * this.waterMod;
                this.currentRotation %= 360.0f;
                if (this.getBlockWorld().field_73012_v.nextInt(100) == 0) {
                    this.getBlockWorld().func_184133_a(null, this.field_174879_c, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5f, this.getBlockWorld().field_73012_v.nextFloat() * 0.25f + 0.25f);
                }
            } else {
                this.previousRotation = 0.0f;
                this.currentRotation = 0.0f;
            }
        }
    }

    public boolean isOverworld() {
        return this.field_145850_b.field_73011_w.func_76569_d();
    }

    public boolean isEnd() {
        return this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.THE_END;
    }

    public boolean isNether() {
        return this.field_145850_b.field_73011_w.func_177495_o();
    }

    public void setPower(byte power) {
        this.power = power;
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)IBlockActive.ACTIVE, (Comparable)Boolean.valueOf(power > 0)));
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Gameplay.generatorRenderDistance * Gameplay.generatorRenderDistance;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return this.power;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 0;
    }

    public EnumFacing getOrientation() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockAxleGenerator) {
            EnumFacing.Axis axis = (EnumFacing.Axis)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(DirUtils.AXIS);
            switch (axis) {
                case X: {
                    return EnumFacing.EAST;
                }
                case Z: {
                    return EnumFacing.SOUTH;
                }
            }
            return EnumFacing.UP;
        }
        return EnumFacing.UP;
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return this.func_145838_q();
    }
}

