/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockPump;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockTemporaryWater
extends BlockLiquid {
    public BlockTemporaryWater() {
        super(Material.field_151586_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(4)));
        this.func_149675_a(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int level = (Integer)state.func_177229_b((IProperty)field_176367_b);
        IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
        if (stateBelow.func_177230_c() != BWMBlocks.PUMP || !((Boolean)stateBelow.func_177229_b((IProperty)BlockPump.ACTIVE)).booleanValue() || !BlockPump.hasWaterToPump(worldIn, pos.func_177977_b())) {
            worldIn.func_175698_g(pos);
            return;
        }
        if (this.canFlowInto(worldIn, pos.func_177977_b(), stateBelow)) {
            if (level >= 8) {
                this.tryFlowInto(worldIn, pos.func_177977_b(), stateBelow, level);
            } else {
                this.tryFlowInto(worldIn, pos.func_177977_b(), stateBelow, level + 8);
            }
        } else if (level >= 0 && (level == 0 || this.isBlocked(worldIn, pos.func_177977_b(), stateBelow))) {
            Set<EnumFacing> set = this.getPossibleFlowDirections(worldIn, pos);
            int nextLevel = level + 1;
            if (level >= 8) {
                nextLevel = 1;
            }
            if (nextLevel >= 8) {
                return;
            }
            for (EnumFacing facing : set) {
                this.tryFlowInto(worldIn, pos.func_177972_a(facing), worldIn.func_180495_p(pos.func_177972_a(facing)), nextLevel);
            }
        }
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    private boolean canFlowInto(World worldIn, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(worldIn, pos, state);
    }

    private void tryFlowInto(World worldIn, BlockPos pos, IBlockState state, int level) {
        if (this.canFlowInto(worldIn, pos, state)) {
            if (state.func_185904_a() != Material.field_151579_a) {
                state.func_177230_c().func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_180501_a(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    private boolean isBlocked(World worldIn, BlockPos pos, IBlockState state) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block instanceof BlockDoor || block == Blocks.field_150472_an || block == Blocks.field_150468_ap || block == Blocks.field_150436_aH || state.func_185904_a() == Material.field_151567_E || state.func_185904_a() == Material.field_189963_J || state.func_185904_a().func_76230_c();
    }

    private Set<EnumFacing> getPossibleFlowDirections(World worldIn, BlockPos pos) {
        int i = 1000;
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate;
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            if (this.isBlocked(worldIn, blockpos, iblockstate = worldIn.func_180495_p(blockpos)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            int j = this.isBlocked(worldIn, blockpos.func_177977_b(), worldIn.func_180495_p(blockpos.func_177977_b())) ? this.getSlopeDistance(worldIn, blockpos, 1, enumfacing.func_176734_d()) : 0;
            if (j < i) {
                set.clear();
            }
            if (j > i) continue;
            set.add(enumfacing);
            i = j;
        }
        return set;
    }

    private int getSlopeDistance(World worldIn, BlockPos pos, int distance, EnumFacing calculateFlowCost) {
        int i = 1000;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            int j;
            IBlockState iblockstate;
            BlockPos blockpos;
            if (enumfacing == calculateFlowCost || this.isBlocked(worldIn, blockpos = pos.func_177972_a(enumfacing), iblockstate = worldIn.func_180495_p(blockpos)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            if (!this.isBlocked(worldIn, blockpos.func_177977_b(), iblockstate)) {
                return distance;
            }
            if (distance >= 4 || (j = this.getSlopeDistance(worldIn, blockpos, distance + 1, enumfacing.func_176734_d())) >= i) continue;
            i = j;
        }
        return i;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176365_e(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }
}

