/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api.recipe.impl;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CombinedOutputs
implements IRecipeOutputs {
    private List<IRecipeOutputs> recipeOutputs;

    public CombinedOutputs(IRecipeOutputs ... recipeOutputs) {
        this(Lists.newArrayList((Object[])recipeOutputs));
    }

    public CombinedOutputs(List<IRecipeOutputs> recipeOutputs) {
        this.recipeOutputs = recipeOutputs;
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return InvUtils.asNonnullList(this.recipeOutputs.stream().map(IRecipeOutputs::getOutputs).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    public List<IOutput> getDisplayOutputs() {
        return InvUtils.asNonnullList(this.recipeOutputs.stream().map(IRecipeOutputs::getDisplayOutputs).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    public boolean matches(List<ItemStack> outputs) {
        return this.recipeOutputs.stream().allMatch(r -> r.matches(outputs));
    }

    @Override
    public boolean matchesFuzzy(List<ItemStack> outputs) {
        return this.recipeOutputs.stream().allMatch(r -> r.matchesFuzzy(outputs));
    }

    @Override
    public boolean isInvalid() {
        return this.recipeOutputs.stream().anyMatch(IRecipeOutputs::isInvalid);
    }
}

