/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/genlayers/GenLayerCombineWhitelist", classExplaination="A layer used to combine two parent layers using a whitelist. If the biome from the first parent is in the whitelist, it's used, otherwise the biome from the second parent is used. This is useful for doing things like combining a heat map and a terrain map.")
public class GenLayerCombineWhitelist
extends GenLayer {
    private final GenLayer parent2;
    private int[] whitelist;

    @ScriptArgs(args={ArgType.LONG, ArgType.GENLAYER, ArgType.GENLAYER, ArgType.NON_NULL_BIOME_ID_ARRAY})
    @ScriptMethodDocumentation(usage="base layer seed, first parent layer, second parent layer, whitelist", notes="Constructs the layer with its seed, parent layers and whitelist.")
    public GenLayerCombineWhitelist(long seed, GenLayer parent, GenLayer parent2, int[] whitelist) {
        super(seed);
        this.field_75909_a = parent;
        this.parent2 = parent2;
        this.whitelist = whitelist;
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] parentInts2 = this.parent2.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                int parentIndex = x + 1 + (z + 1) * (width + 2);
                int currentBiome = parentInts[parentIndex];
                int currentBiome2 = parentInts2[parentIndex];
                returnInts[x + z * width] = this.inWhitelist(currentBiome) ? currentBiome : currentBiome2;
            }
        }
        return returnInts;
    }

    private boolean inWhitelist(int id) {
        for (int i : this.whitelist) {
            if (id != i) continue;
            return true;
        }
        return false;
    }
}

