/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util.noise;

import com.bloodnbonesgaming.dimensionalcontrol.util.noise.OpenSimplexNoiseGenerator;

public class OpenSimplexNoiseGeneratorOctaves {
    protected final OpenSimplexNoiseGenerator generator;

    public OpenSimplexNoiseGeneratorOctaves(long seed) {
        this.generator = new OpenSimplexNoiseGenerator(seed);
    }

    public double eval(double x, double y, double z, int octaves, double persistence) {
        double total = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        double maxValue = 0.0;
        for (int i = 0; i < octaves; ++i) {
            total += (this.generator.eval(x * frequency, y * frequency, z * frequency) + 1.0) / 2.0 * amplitude;
            maxValue += amplitude;
            amplitude *= persistence;
            frequency *= 2.0;
        }
        return total / maxValue;
    }

    public double eval(double x, double y, double z, double startingFeatureSize, int octaves, double persistence) {
        return this.eval(x / startingFeatureSize, y / startingFeatureSize, z / startingFeatureSize, octaves, persistence);
    }

    public double[] eval(double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, double x, double y, double z, int octaves, double persistence, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale, double xScale, double yScale, double zScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    array[index] = this.eval((x + (double)(xI * xCoordinateScale)) / xScale, yScale == 0.0 ? 0.0 : (y + (double)(yI * yCoordinateScale)) / yScale, (z + (double)(zI * zCoordinateScale)) / zScale, octaves, persistence) * 2.0 - 1.0;
                }
            }
        }
        return array;
    }

    public double eval(double x, double z, int octaves, double persistence) {
        double total = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        double maxValue = 0.0;
        for (int i = 0; i < octaves; ++i) {
            total += (this.generator.eval(x * frequency, z * frequency) + 1.0) / 2.0 * amplitude;
            maxValue += amplitude;
            amplitude *= persistence;
            frequency *= 2.0;
        }
        return total / maxValue;
    }
}

