/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomLight;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomMedium;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionSingle;
import com.bloodnbonesgaming.dimensionalcontrol.util.IOHelper;
import com.bloodnbonesgaming.dimensionalcontrol.world.biomeprovider.BiomeProviderCustomLight;
import com.bloodnbonesgaming.dimensionalcontrol.world.biomeprovider.BiomeProviderCustomMedium;
import com.bloodnbonesgaming.dimensionalcontrol.world.biomeprovider.BiomeProviderSkyIsland2;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;

public enum BiomeProviderType {
    SURFACE{

        @Override
        protected BiomeProvider createBiomeProvider(World world, BiomeProviderDefinition definition) {
            return new BiomeProvider(world.func_72912_H());
        }

        @Override
        protected BiomeProviderDefinition createBiomeProviderDefinition(String scriptName) {
            return new BiomeProviderDefinition(this);
        }
    }
    ,
    SINGLE{

        @Override
        protected BiomeProvider createBiomeProvider(World world, BiomeProviderDefinition definition) {
            return new BiomeProviderSingle(((BiomeProviderDefinitionSingle)definition).getBiome());
        }

        @Override
        protected BiomeProviderDefinition createBiomeProviderDefinition(String scriptName) {
            BiomeProviderDefinitionSingle definition = new BiomeProviderDefinitionSingle(this);
            IOHelper.loadBiomeProviderDefinition(scriptName, definition);
            return definition;
        }
    }
    ,
    CUSTOM_LIGHT{

        @Override
        protected BiomeProvider createBiomeProvider(World world, BiomeProviderDefinition definition) {
            return new BiomeProviderCustomLight(world, (BiomeProviderDefinitionCustomLight)definition);
        }

        @Override
        protected BiomeProviderDefinition createBiomeProviderDefinition(String scriptName) {
            BiomeProviderDefinitionCustomLight definition = new BiomeProviderDefinitionCustomLight(this);
            IOHelper.loadBiomeProviderDefinition(scriptName, definition);
            return definition;
        }
    }
    ,
    CUSTOM_MEDIUM{

        @Override
        protected BiomeProvider createBiomeProvider(World world, BiomeProviderDefinition definition) {
            BiomeProviderCustomMedium provider = new BiomeProviderCustomMedium();
            provider.init(world, (BiomeProviderDefinitionCustomMedium)definition);
            return provider;
        }

        @Override
        protected BiomeProviderDefinition createBiomeProviderDefinition(String scriptName) {
            return new BiomeProviderDefinitionCustomMedium(this, scriptName);
        }
    }
    ,
    SKY_ISLANDS{

        @Override
        protected BiomeProvider createBiomeProvider(World world, BiomeProviderDefinition definition) {
            BiomeProviderSkyIsland2 provider = new BiomeProviderSkyIsland2(world);
            return provider;
        }

        @Override
        protected BiomeProviderDefinition createBiomeProviderDefinition(String scriptName) {
            return new BiomeProviderDefinition(this);
        }
    };


    protected abstract BiomeProvider createBiomeProvider(World var1, BiomeProviderDefinition var2);

    protected abstract BiomeProviderDefinition createBiomeProviderDefinition(String var1);

    public BiomeProvider getBiomeProvider(World world, BiomeProviderDefinition definition) {
        BiomeProvider provider = this.createBiomeProvider(world, definition);
        if (provider == null) {
            DimensionalControl.instance.getLog().error((Object)("No BiomeProvider found for: " + this.toString()));
        }
        return provider;
    }

    public static BiomeProviderDefinition getBiomeProviderDefinition(String typeID, String scriptName) {
        BiomeProviderType type = BiomeProviderType.valueOf(typeID.toUpperCase());
        if (type != null) {
            BiomeProviderDefinition definition = type.createBiomeProviderDefinition(scriptName);
            if (definition != null) {
                return definition;
            }
            DimensionalControl.instance.getLog().error((Object)("No BiomeProviderDefinition found for: " + typeID));
        } else {
            DimensionalControl.instance.getLog().error((Object)("No BiomeProvider found for: " + typeID));
        }
        return null;
    }

    public static BiomeProviderDefinition getBiomeProviderDefinition(BiomeProviderType type, String scriptName) {
        BiomeProviderDefinition definition = type.createBiomeProviderDefinition(scriptName);
        if (definition != null) {
            return definition;
        }
        DimensionalControl.instance.getLog().error((Object)("No BiomeProviderDefinition found for: " + (Object)((Object)type)));
        return null;
    }
}

