/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.util.MapGenNames;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.List;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/chunkgenerators/ChunkGenerator", classExplaination="The role of a ChunkGenerator is to handle all things related to terrain and structure generation.")
public class ChunkGeneratorDefinition {
    private final List<MapGenNames> disabledMapGen = new ArrayList<MapGenNames>();
    private String generationOptions;

    @ScriptMethodDocumentation(args="String", usage="Disables the provided MapGen type. Types are \"CAVES\", \"CAVES_NETHER\", \"RAVINE\", \"END_CITY\", \"MINESHAFT\", \"NETHER_BRIDGE\", \"SCATTERED_FEATURE\", \"STRONGHOLD\", \"VILLAGE\", \"OCEAN_MONUMENT\"")
    public void disableMapGen(String mapGenName) {
        MapGenNames name = MapGenNames.valueOf(mapGenName.toUpperCase());
        if (name != null) {
            this.disabledMapGen.add(name);
        } else {
            DimensionalControl.instance.getLog().error((Object)("No Map Gen for name " + mapGenName + " found."));
        }
    }

    public boolean shouldDisableMapGen(MapGenNames name) {
        return this.disabledMapGen.contains((Object)name);
    }

    @ScriptMethodDocumentation(args="Json", usage="vanilla generation options string", notes="Sets the generator options string. This is the string used by the various vanilla customizable ChunkGenerators for customizing the world generation.")
    public void setGenerationOptions(String generationOptions) {
        this.generationOptions = generationOptions;
    }

    public String getGenerationOptions() {
        return this.generationOptions;
    }
}

