/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacement;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacementFull;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacementType;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionSingle;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.worldprovider.WorldProviderDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.util.BiomeProviderType;
import com.bloodnbonesgaming.dimensionalcontrol.util.ChunkGeneratorType;
import com.bloodnbonesgaming.dimensionalcontrol.util.IOHelper;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/dimensions/DimensionScript", classExplaination="This is where the main things can be configured for each dimension. WorldProvider, ChunkGenerator, BiomeProvider and BlockReplacements.")
public class DimensionDefinition {
    private final List<BlockReplacement> blockReplacements = new ArrayList<BlockReplacement>();
    private BiomeProviderDefinition biomeProviderDefinition;
    private ChunkGeneratorType chunkGeneratorType;
    private ChunkGeneratorDefinition chunkGeneratorDefinition;
    private DimensionType worldProviderType;
    private WorldProviderDefinition worldProiderDefinition;

    public DimensionType getWorldProviderType() {
        return this.worldProviderType;
    }

    public WorldProviderDefinition getWorldProviderDefinition() {
        return this.worldProiderDefinition;
    }

    @ScriptMethodDocumentation(args="String, String", usage="script name, WorldProvider type", notes="Used to set the WorldProvider script and WorldProvider type. Either option can be null. Type options are \"Overworld\", \"Nether\", \"The End\"")
    public void setWorldProvider(String scriptName, String providerType) {
        if (providerType != null) {
            this.setWorldProviderType(providerType);
        }
        if (scriptName != null) {
            this.setWorldProviderScript(scriptName);
        }
    }

    @ScriptMethodDocumentation(args="String", usage="script name", notes="Used to set the WorldProvider script.")
    public void setWorldProviderScript(String scriptName) {
        WorldProviderDefinition definition = new WorldProviderDefinition();
        IOHelper.loadWorldProviderDefinition(scriptName, definition);
        if (definition != null) {
            this.worldProiderDefinition = definition;
        }
    }

    @ScriptMethodDocumentation(args="String", usage="WorldProvider type", notes="Sets the WorldProvider type. Options are \"Overworld\", \"Nether\", \"The End\"")
    public void setWorldProviderType(String providerType) {
        for (DimensionType type : DimensionType.values()) {
            if (!type.func_186065_b().equalsIgnoreCase(providerType)) continue;
            this.worldProviderType = type;
            return;
        }
        DimensionalControl.instance.getLog().error((Object)(providerType + " is not a recognized WorldProvider type."));
    }

    public ChunkGeneratorDefinition getChunkGeneratorDefinition() {
        return this.chunkGeneratorDefinition;
    }

    @ScriptMethodDocumentation(args="ChunkGeneratorDefinition", usage="definition", notes="Sets the ChunkGeneratorDefinition for the dimension to the provided one.")
    public ChunkGeneratorDefinition setChunkGeneratorDefinition(ChunkGeneratorDefinition definition) {
        this.chunkGeneratorDefinition = definition;
        return this.chunkGeneratorDefinition;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the ChunkGeneratorDefinition object for the dimension and returns it, so functions can be called on it. The same functions that can be called in a chunkgenerators script, can be called on this object. Documentation can be found in documentation/chunkgenerators/ChunkGenerator.txt")
    public ChunkGeneratorDefinition setChunkGeneratorDefinition() {
        return this.setChunkGeneratorDefinition((String)null);
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the ChunkGeneratorDefinition object for the dimension to the provided type and returns it, so functions can be called on it. The same functions that can be called in a chunkgenerators script, can be called on this object. Documentation can be found in documentation/chunkgenerators")
    public ChunkGeneratorDefinition setChunkGeneratorDefinition(String typeID) {
        if (typeID == null) {
            this.chunkGeneratorDefinition = new ChunkGeneratorDefinition();
        } else {
            ChunkGeneratorType type = ChunkGeneratorType.valueOf(typeID.toUpperCase());
            if (type != null) {
                this.chunkGeneratorType = type;
                this.chunkGeneratorDefinition = type.createDefinition();
            } else {
                DimensionalControl.instance.getLog().error((Object)("No ChunkGeneratorType exists for: " + typeID));
                this.chunkGeneratorDefinition = new ChunkGeneratorDefinition();
            }
        }
        return this.chunkGeneratorDefinition;
    }

    @ScriptMethodDocumentation(args="String", usage="script name", notes="Sets the ChunkGenerator script.")
    public void setChunkGeneratorScript(String scriptName) {
        this.setChunkGenerator(scriptName, null);
    }

    @ScriptMethodDocumentation(args="String, String", usage="script name, ChunkGenerator type", notes="Sets the ChunkGenerator script and ChunkGenerator type. The ChunkGenerator type can be null. Type options are \"SURFACE\", \"FLAT\", \"HELL\", \"END\", \"VOID\", \"SKY_ISLANDS\"")
    public void setChunkGenerator(String scriptName, String typeID) {
        if (typeID == null) {
            ChunkGeneratorDefinition definition = new ChunkGeneratorDefinition();
            IOHelper.loadChunkGeneratorDefinition(scriptName, definition);
            if (definition != null) {
                this.chunkGeneratorDefinition = definition;
            }
        } else {
            ChunkGeneratorType type = ChunkGeneratorType.valueOf(typeID.toUpperCase());
            if (type != null) {
                this.chunkGeneratorType = type;
                ChunkGeneratorDefinition definition = type.createDefinition();
                IOHelper.loadChunkGeneratorDefinition(scriptName, definition);
                if (definition != null) {
                    this.chunkGeneratorDefinition = definition;
                }
            } else {
                DimensionalControl.instance.getLog().error((Object)("No ChunkGeneratorType exists for: " + typeID));
                ChunkGeneratorDefinition definition = new ChunkGeneratorDefinition();
                IOHelper.loadChunkGeneratorDefinition(scriptName, definition);
                if (definition != null) {
                    this.chunkGeneratorDefinition = definition;
                }
            }
        }
    }

    @ScriptMethodDocumentation(args="String", usage="ChunkProvider type", notes="Used to set the ChunkGenerator type. Type options are \"SURFACE\", \"FLAT\", \"HELL\", \"END\", \"VOID\", \"SKY_ISLANDS\"")
    public void setChunkGeneratorType(String typeID) {
        ChunkGeneratorType type = ChunkGeneratorType.valueOf(typeID.toUpperCase());
        if (type != null) {
            this.chunkGeneratorType = type;
        } else {
            DimensionalControl.instance.getLog().error((Object)("No ChunkGeneratorType exists for: " + typeID));
        }
    }

    public IChunkGenerator getChunkGenerator(World world) {
        if (this.chunkGeneratorType != null) {
            return this.chunkGeneratorType.getChunkGenerator(world, this.chunkGeneratorDefinition);
        }
        return null;
    }

    @ScriptMethodDocumentation(usage="biome ID", notes="Sets the dimension to use the \"SINGLE\" BiomeProvider type and sets the biome as the provided biome ID.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    public void setBiomeProviderSingle(int biomeID) {
        BiomeProviderDefinitionSingle definition = new BiomeProviderDefinitionSingle(BiomeProviderType.SINGLE);
        definition.setBiome(biomeID);
        this.biomeProviderDefinition = definition;
    }

    public BiomeProvider getBiomeProvider(World world) {
        if (this.biomeProviderDefinition != null) {
            return this.biomeProviderDefinition.getBiomeProvider(world);
        }
        return null;
    }

    public BiomeProviderDefinition getBiomeProviderDefinition() {
        return this.biomeProviderDefinition;
    }

    @ScriptMethodDocumentation(args="String, String", usage="script name, BiomeProvider type", notes="Used to set the BiomeProvider script and BiomeProvider type. Neither option may be null. Type options are \"SURFACE\", \"SINGLE\", \"CUSTOM_LIGHT\", \"CUSTOM_MEDIUM\"")
    public void setBiomeProvider(String scriptName, String typeID) {
        BiomeProviderDefinition definition = BiomeProviderType.getBiomeProviderDefinition(typeID, scriptName);
        if (definition != null) {
            this.biomeProviderDefinition = definition;
        }
    }

    public void setBiomeProvider(BiomeProviderDefinition definition) {
        this.biomeProviderDefinition = definition;
    }

    @ScriptMethodDocumentation(args="String, String", usage="script name, BlockReplacement type", notes="Used to add a BlockReplacement script of the provided type. Type options are \"Simple\"")
    public void addBlockReplacement(String scriptName, String typeID) {
        BlockReplacement baseReplacement = BlockReplacementType.getBlockReplacement(typeID);
        BlockReplacement replacement = baseReplacement != null ? baseReplacement : new BlockReplacement();
        IOHelper.loadBlockReplacement(scriptName, replacement);
        if (replacement != null) {
            this.blockReplacements.add(replacement);
        }
    }

    @ScriptMethodDocumentation(args="String", usage="BlockReplacement type", notes="Adds a BlockReplacement to the dimension with the provided type, and returns it, so functions can be run on it. Type options are \"Simple\". The same functions that can be called in a blockreplacement script, can be called on this object. Documentation can be found in documentation/blockreplacements")
    public BlockReplacement addBlockReplacement(String typeID) throws Exception {
        BlockReplacement replacement = BlockReplacementType.getBlockReplacement(typeID);
        if (replacement != null) {
            this.blockReplacements.add(replacement);
            return replacement;
        }
        throw new Exception(typeID + " is not a block replacement type!");
    }

    @ScriptMethodDocumentation(usage="", notes="Adds a BlockReplacement to the dimension and returns it, so functions can be run on it. The same functions that can be called in a blockreplacement script, can be called on this object. Documentation can be found in documentation/blockreplacements")
    public BlockReplacement addBlockReplacement() {
        BlockReplacementFull replacement = new BlockReplacementFull();
        this.blockReplacements.add(replacement);
        return replacement;
    }

    public List<BlockReplacement> getBlockReplacements() {
        return this.blockReplacements;
    }
}

