/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.blockreplacement;

import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacement;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.GenerationPoint;
import com.bloodnbonesgaming.dimensionalcontrol.config.ConfigurationManager;
import com.bloodnbonesgaming.dimensionalcontrol.config.DimensionDefinition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockReplacer {
    public static void replaceBlocks(GenerationPoint point, WorldServer world, int chunkX, int chunkZ) {
        DimensionDefinition definition;
        if (!world.field_72995_K && (definition = ConfigurationManager.getInstance().getDimensionDefinition(world.field_73011_w.getDimension())) != null) {
            ArrayList<BlockReplacement> replacements = new ArrayList<BlockReplacement>();
            for (BlockReplacement replacement : definition.getBlockReplacements()) {
                if (!replacement.shouldRunForGenerationPoint(point)) continue;
                replacements.add(replacement);
            }
            if (replacements.size() > 0) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                int realChunkX = chunkX / 16;
                int realChunkZ = chunkZ / 16;
                Chunk chunk = world.func_72964_e(realChunkX, realChunkZ);
                BlockReplacer.replaceChunkSafe(world, chunk, chunkX, chunkZ, replacements, pos);
                chunk = world.func_72964_e(realChunkX + 1, realChunkZ);
                BlockReplacer.replaceChunkSafe(world, chunk, chunkX, chunkZ, replacements, pos);
                chunk = world.func_72964_e(realChunkX, realChunkZ + 1);
                BlockReplacer.replaceChunkSafe(world, chunk, chunkX, chunkZ, replacements, pos);
                chunk = world.func_72964_e(realChunkX + 1, realChunkZ + 1);
                BlockReplacer.replaceChunkSafe(world, chunk, chunkX, chunkZ, replacements, pos);
            }
        }
    }

    public static void replaceBlocks(GenerationPoint point, WorldServer world, ChunkPrimer primer, int chunkX, int chunkZ) {
        DimensionDefinition definition;
        if (!world.field_72995_K && (definition = ConfigurationManager.getInstance().getDimensionDefinition(world.field_73011_w.getDimension())) != null) {
            ArrayList<BlockReplacement> replacements = new ArrayList<BlockReplacement>();
            for (BlockReplacement replacement : definition.getBlockReplacements()) {
                if (!replacement.shouldRunForGenerationPoint(point)) continue;
                replacements.add(replacement);
            }
            if (replacements.size() > 0) {
                for (int x = 0; x < 16; ++x) {
                    int realX = x + chunkX;
                    for (int z = 0; z < 16; ++z) {
                        int realZ = z + chunkZ;
                        block3: for (int y = 0; y < 256; ++y) {
                            IBlockState state = null;
                            for (BlockReplacement blockReplacement : replacements) {
                                IBlockState replacement;
                                if (!blockReplacement.shouldRunForLocation(world, realX, y, realZ)) continue;
                                if (state == null) {
                                    state = primer.func_177856_a(x, y, z);
                                }
                                if ((replacement = blockReplacement.replace(world, state, realX, y, realZ)) == null || state == replacement) continue;
                                primer.func_177855_a(x, y, z, replacement);
                                continue block3;
                            }
                        }
                    }
                }
            }
        }
    }

    public static void replaceChunkSafe(WorldServer world, Chunk chunk, int chunkX, int chunkZ, List<BlockReplacement> replacements, BlockPos.MutableBlockPos pos) {
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX;
            for (int z = 0; z < 16; ++z) {
                int realZ = z + chunkZ;
                block2: for (int y = 0; y < 256; ++y) {
                    IBlockState state = null;
                    for (BlockReplacement blockReplacement : replacements) {
                        IBlockState replacement;
                        if (!blockReplacement.shouldRunForLocation(world, realX, y, realZ)) continue;
                        if (state == null) {
                            state = chunk.func_186032_a(x, y, z);
                        }
                        if ((replacement = blockReplacement.replace(world, state, realX, y, realZ)) == null || state == replacement) continue;
                        pos.func_181079_c(realX, y, realZ);
                        chunk.func_177436_a((BlockPos)pos, replacement);
                        continue block2;
                    }
                }
            }
        }
    }

    public static void replaceChunkUnsafe(WorldServer world, Chunk chunk, int chunkX, int chunkZ, List<BlockReplacement> replacements, int minHeight, int maxHeight) {
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        boolean flag = world.field_73011_w.func_191066_m();
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        boolean changed = false;
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX;
            for (int z = 0; z < 16; ++z) {
                int realZ = z + chunkZ;
                for (int y = minHeight; y <= maxHeight; ++y) {
                    IBlockState replacement;
                    IBlockState state;
                    int i1 = y >> 4;
                    if (storageArrays[i1] == Chunk.field_186036_a) {
                        state = air;
                        for (BlockReplacement blockReplacement : replacements) {
                            replacement = blockReplacement.replace(world, state, realX, y, realZ);
                            if (replacement == null || replacement == state) continue;
                            storageArrays[i1] = new ExtendedBlockStorage(i1 << 4, flag);
                            storageArrays[i1].func_177484_a(x, y & 0xF, z, replacement);
                            changed = true;
                        }
                        continue;
                    }
                    state = storageArrays[i1].func_177485_a(x, y & 0xF, z);
                    for (BlockReplacement blockReplacement : replacements) {
                        replacement = blockReplacement.replace(world, state, realX, y, realZ);
                        if (replacement == null || replacement == state) continue;
                        storageArrays[i1].func_177484_a(x, y & 0xF, z, replacement);
                        changed = true;
                    }
                }
            }
        }
        if (changed) {
            chunk.func_76603_b();
        }
    }
}

