/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.book.content;

import c4.conarm.common.ConstructsRegistry;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.armor.ArmorPart;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementText;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.content.ContentTool;
import slimeknights.tconstruct.library.book.elements.ElementTinkerItem;
import slimeknights.tconstruct.library.materials.Material;

public class ContentArmor
extends TinkerPage {
    public static final transient String ID = "armor";
    private transient List<ArmorCore> armor;
    private transient List<ArmorPart> coreParts;
    public TextData[] text = new TextData[0];
    public String[] properties = new String[0];

    public ContentArmor() {
    }

    public ContentArmor(List<ArmorCore> armor) {
        this.armor = armor;
    }

    public void load() {
        if (this.armor == null) {
            this.armor = new ArrayList<ArmorCore>();
            this.armor = ArmoryRegistry.getArmor().stream().filter(armorCore -> armorCore.getAppearanceName().equals("classic")).collect(Collectors.toList());
        }
        if (this.coreParts == null) {
            this.coreParts = new ArrayList<ArmorPart>();
            this.coreParts.addAll(Lists.newArrayList((Object[])new ArmorPart[]{ConstructsRegistry.helmetCore, ConstructsRegistry.chestCore, ConstructsRegistry.leggingsCore, ConstructsRegistry.bootsCore}));
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        this.addTitle(list, this.parent.translate("armor.title"));
        int padding = 5;
        int h = GuiBook.PAGE_WIDTH / 3 - 10;
        int y = 16;
        list.add((BookElement)new ElementText(padding, y, GuiBook.PAGE_WIDTH - padding * 2, h, this.text));
        ImageData img = ContentTool.IMG_SLOTS;
        int imgX = GuiBook.PAGE_WIDTH - img.width - 8;
        int imgY = GuiBook.PAGE_HEIGHT - img.height - 16;
        int armorX = imgX + (img.width - 16) / 2;
        int armorY = imgY + 28;
        y = imgY - 6;
        if (this.properties.length > 0) {
            TextData head = new TextData(this.parent.translate("armor.properties"));
            head.underlined = true;
            list.add((BookElement)new ElementText(padding, y, 86 - padding, GuiBook.PAGE_HEIGHT - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.properties) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new ElementText(padding, y += 10, GuiBook.PAGE_WIDTH / 2 + 5, GuiBook.PAGE_HEIGHT - h - 20, (Collection)effectData));
        }
        int[] slotX = new int[]{-21, -25, 0, 25, 21};
        int[] slotY = new int[]{22, -4, -25, -4, 22};
        list.add((BookElement)new ElementImage(imgX + (img.width - ContentTool.IMG_TABLE.width) / 2, imgY + 28, -1, -1, ContentTool.IMG_TABLE));
        list.add((BookElement)new ElementImage(imgX, imgY, -1, -1, img, book.appearance.slotColor));
        ItemStackList demo = this.getDemoArmor();
        ElementTinkerItem toolItem = new ElementTinkerItem(armorX, armorY, 1.0f, (Collection)demo);
        toolItem.noTooltip = true;
        list.add((BookElement)toolItem);
        list.add((BookElement)new ElementImage(armorX - 3, armorY - 3, -1, -1, ContentTool.IMG_SLOT_1, 0xFFFFFF));
        Material material = this.armor.get(0).getMaterialForPartForGuiRendering(0);
        ItemStackList stacks = ItemStackList.withSize((int)this.coreParts.size());
        for (int i = 0; i < this.coreParts.size(); ++i) {
            stacks.set(i, (Object)this.coreParts.get(i).getItemstackWithMaterial(material));
        }
        ElementTinkerItem partItem = new ElementTinkerItem(armorX + slotX[0], armorY + slotY[0], 1.0f, (Collection)stacks);
        partItem.noTooltip = true;
        list.add((BookElement)partItem);
        ElementTinkerItem plateItem = new ElementTinkerItem(armorX + slotX[1], armorY + slotY[1], 1.0f, ConstructsRegistry.armorPlate.getItemstackWithMaterial(this.armor.get(0).getMaterialForPartForGuiRendering(1)));
        plateItem.noTooltip = true;
        list.add((BookElement)plateItem);
        ElementTinkerItem trimItem = new ElementTinkerItem(armorX + slotX[2], armorY + slotY[2], 1.0f, ConstructsRegistry.armorTrim.getItemstackWithMaterial(this.armor.get(0).getMaterialForPartForGuiRendering(2)));
        trimItem.noTooltip = true;
        list.add((BookElement)trimItem);
    }

    protected ItemStackList getDemoArmor() {
        ItemStackList demo = ItemStackList.withSize((int)this.armor.size());
        for (int i = 0; i < this.armor.size(); ++i) {
            if (this.armor.get(i) != null) {
                demo.set(i, (Object)this.armor.get(i).buildItemForRenderingInGui());
                continue;
            }
            if (this.armor == null) continue;
            demo.set(i, (Object)new ItemStack((Item)this.armor.get(i)));
        }
        return demo;
    }
}

