/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.integrations.crafttweaker.materials;

import c4.conarm.integrations.crafttweaker.actions.SetDefenseAction;
import c4.conarm.integrations.crafttweaker.actions.SetDurabilityAction;
import c4.conarm.integrations.crafttweaker.actions.SetModifierAction;
import c4.conarm.integrations.crafttweaker.actions.SetToughnessAction;
import c4.conarm.integrations.crafttweaker.materials.ConArmMatDefinition;
import c4.conarm.integrations.crafttweaker.materials.IConArmMatDefinition;
import c4.conarm.integrations.crafttweaker.materials.IConArmMaterial;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import slimeknights.tconstruct.library.materials.Material;

public class ConArmMaterial
implements IConArmMaterial {
    private final Material material;

    public ConArmMaterial(Material material) {
        this.material = material;
    }

    @Override
    public String getName() {
        return this.material.getIdentifier();
    }

    @Override
    public boolean matches(IConArmMaterial other) {
        return other.getName().equals(this.getName());
    }

    @Override
    public IConArmMatDefinition getDefinition() {
        return new ConArmMatDefinition(this.material);
    }

    @Override
    public Object getInternal() {
        return this.material;
    }

    @Override
    public void setDurabilityCore(float durability) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, ArmorMaterialType.CORE, durability));
    }

    @Override
    public float getDurabilityCore() {
        return ((CoreMaterialStats)this.material.getStats((String)ArmorMaterialType.CORE)).durability;
    }

    @Override
    public void setDurabilityPlates(float durability) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, ArmorMaterialType.PLATES, durability));
    }

    @Override
    public float getDurabilityPlates() {
        return ((PlatesMaterialStats)this.material.getStats((String)ArmorMaterialType.PLATES)).durability;
    }

    @Override
    public void setDurabilityTrim(float durability) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, ArmorMaterialType.TRIM, durability));
    }

    @Override
    public float getDurabilityTrim() {
        return ((TrimMaterialStats)this.material.getStats((String)ArmorMaterialType.TRIM)).extraDurability;
    }

    @Override
    public void setDefense(float defense) {
        CraftTweakerAPI.apply((IAction)new SetDefenseAction(this, defense));
    }

    @Override
    public float getDefense() {
        return ((CoreMaterialStats)this.material.getStats((String)ArmorMaterialType.CORE)).defense;
    }

    @Override
    public void setModifier(float modifier) {
        CraftTweakerAPI.apply((IAction)new SetModifierAction(this, modifier));
    }

    @Override
    public float getModifier() {
        return ((PlatesMaterialStats)this.material.getStats((String)ArmorMaterialType.PLATES)).modifier;
    }

    @Override
    public void setToughness(float toughness) {
        CraftTweakerAPI.apply((IAction)new SetToughnessAction(this, toughness));
    }

    @Override
    public float getToughness() {
        return ((PlatesMaterialStats)this.material.getStats((String)ArmorMaterialType.PLATES)).toughness;
    }
}

