/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.tiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import primal_tech.blocks.BlockWoodenHopper;
import primal_tech.inventory.WoodenHopperItemHandler;
import primal_tech.tiles.TileEntityInventoryHelper;

public class TileEntityWoodenHopper
extends TileEntityInventoryHelper
implements ITickable,
IHopper {
    private static final int[] SLOTS = new int[]{0, 1, 2, 3};
    public byte rotation = 0;
    private int transferCooldown = -1;
    private long tickedGameTime;

    public TileEntityWoodenHopper() {
        super(4);
    }

    public static void registerFixesHopper(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityWoodenHopper.class, new String[]{"Items"}));
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.transferCooldown = nbt.func_74762_e("TransferCooldown");
        this.rotation = nbt.func_74771_c("rotation");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TransferCooldown", this.transferCooldown);
        nbt.func_74774_a("rotation", this.rotation);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
        return itemstack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public String func_70005_c_() {
        return "container.hopper";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper();
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private boolean updateHopper() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown() && BlockWoodenHopper.isEnabled(this.func_145832_p())) {
                boolean flag = false;
                if (!this.isInventoryEmpty()) {
                    flag = this.transferItemsOut();
                }
                if (!this.isFull()) {
                    boolean bl = flag = TileEntityWoodenHopper.captureDroppedItems(this) || flag;
                }
                if (flag) {
                    this.setTransferCooldown(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack itemstack : this.getItems()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.getItems()) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        IInventory iinventory = this.getInventoryForHopperTransfer();
        EnumFacing enumfacing = BlockWoodenHopper.getFacing(this.func_145832_p());
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(enumfacing));
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumfacing.func_176734_d())) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumfacing.func_176734_d());
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                ItemStack stack = this.func_70301_a(i).func_77946_l();
                stack.func_190920_e(1);
                ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                if (!stack1.func_190926_b()) continue;
                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.func_70298_a(i, 1), (boolean)false);
                this.func_70296_d();
                return true;
            }
        } else {
            if (iinventory == null) {
                return false;
            }
            if (this.isInventoryFull(iinventory, enumfacing)) {
                return false;
            }
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                ItemStack stack = this.func_70301_a(i).func_77946_l();
                ItemStack stack1 = TileEntityWoodenHopper.putStackInInventoryAllSlots((IInventory)this, iinventory, this.func_70298_a(i, 1), enumfacing.func_176734_d());
                if (stack1.func_190926_b()) {
                    iinventory.func_70296_d();
                    return true;
                }
                this.func_70299_a(i, stack);
            }
        }
        return false;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int i : aint = isidedinventory.func_180463_a(side)) {
                if (isidedinventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.func_70301_a(k).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean captureDroppedItems(IHopper hopper) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)hopper);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = TileEntityWoodenHopper.getHopperInventory(hopper);
        if (iinventory != null) {
            EnumFacing enumfacing = EnumFacing.DOWN;
            if (TileEntityWoodenHopper.isInventoryEmpty(iinventory, enumfacing)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                for (int i : aint = isidedinventory.func_180463_a(enumfacing)) {
                    if (!TileEntityWoodenHopper.pullItemFromSlot(hopper, iinventory, i, enumfacing)) continue;
                    return true;
                }
            } else {
                int j = iinventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    if (!TileEntityWoodenHopper.pullItemFromSlot(hopper, iinventory, k, enumfacing)) continue;
                    return true;
                }
            }
        } else {
            for (EntityItem entityitem : TileEntityWoodenHopper.getCaptureItems(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB(), hopper.func_96108_aC())) {
                if (!TileEntityWoodenHopper.putDropInInventoryAllSlots(null, (IInventory)hopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, EnumFacing direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && TileEntityWoodenHopper.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = TileEntityWoodenHopper.putStackInInventoryAllSlots(inventoryIn, (IInventory)hopper, inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    public static boolean putDropInInventoryAllSlots(IInventory iInventory, IInventory itemIn, EntityItem entityItem) {
        boolean flag = false;
        if (entityItem == null) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityWoodenHopper.putStackInInventoryAllSlots(iInventory, itemIn, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            entityItem.func_70106_y();
        } else {
            entityItem.func_92058_a(itemstack1);
        }
        return flag;
    }

    protected IItemHandler createUnSidedHandler() {
        return new WoodenHopperItemHandler(this);
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, IInventory stack, ItemStack side, @Nullable EnumFacing facing) {
        if (stack instanceof ISidedInventory && facing != null) {
            ISidedInventory isidedinventory = (ISidedInventory)stack;
            int[] aint = isidedinventory.func_180463_a(facing);
            for (int k = 0; k < aint.length && !side.func_190926_b(); ++k) {
                side = TileEntityWoodenHopper.insertStack(inventoryIn, stack, side, aint[k], facing);
            }
        } else {
            int i = stack.func_70302_i_();
            for (int j = 0; j < i && !side.func_190926_b(); ++j) {
                side = TileEntityWoodenHopper.insertStack(inventoryIn, stack, side, j, facing);
            }
        }
        return side;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !inventoryIn.func_94041_b(index, stack) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private static ItemStack insertStack(IInventory inventoryIn, IInventory stack, ItemStack index, int side, EnumFacing p_174916_4_) {
        ItemStack itemstack = stack.func_70301_a(side);
        if (TileEntityWoodenHopper.canInsertItemInSlot(stack, index, side, p_174916_4_)) {
            boolean flag = false;
            boolean flag1 = stack.func_191420_l();
            if (itemstack.func_190926_b()) {
                stack.func_70299_a(side, index);
                index = ItemStack.field_190927_a;
                flag = true;
            } else if (TileEntityWoodenHopper.canCombine(itemstack, index)) {
                int i = index.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(index.func_190916_E(), i);
                index.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                TileEntityWoodenHopper tileentityhopper1;
                if (flag1 && stack instanceof TileEntityWoodenHopper && !(tileentityhopper1 = (TileEntityWoodenHopper)stack).mayTransfer()) {
                    int k = 0;
                    if (inventoryIn != null && inventoryIn instanceof TileEntityWoodenHopper) {
                        TileEntityWoodenHopper tileentityhopper = (TileEntityWoodenHopper)inventoryIn;
                        if (tileentityhopper1.tickedGameTime >= tileentityhopper.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileentityhopper1.setTransferCooldown(8 - k);
                }
                stack.func_70296_d();
            }
        }
        return index;
    }

    private IInventory getInventoryForHopperTransfer() {
        EnumFacing enumfacing = BlockWoodenHopper.getFacing(this.func_145832_p());
        return TileEntityWoodenHopper.getInventoryAtPosition(this.func_145831_w(), this.func_96107_aA() + (double)enumfacing.func_82601_c(), this.func_96109_aB() + (double)enumfacing.func_96559_d(), this.func_96108_aC() + (double)enumfacing.func_82599_e());
    }

    public static IInventory getHopperInventory(IHopper hopper) {
        return TileEntityWoodenHopper.getInventoryAtPosition(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB() + 1.0, hopper.func_96108_aC());
    }

    public static List<EntityItem> getCaptureItems(World worldIn, double p_184292_1_, double p_184292_3_, double p_184292_5_) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(p_184292_1_ - 0.5, p_184292_3_, p_184292_5_ - 0.5, p_184292_1_ + 0.5, p_184292_3_ + 1.5, p_184292_5_ + 0.5), EntitySelectors.field_94557_a);
    }

    public static IInventory getInventoryAtPosition(World worldIn, double x, double y, double z) {
        List list;
        TileEntity tileentity;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.func_76128_c((double)x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z));
        IBlockState state = worldIn.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state) && (tileentity = worldIn.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof TileEntityChest && block instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_189418_a(worldIn, blockpos, true);
        }
        if (iinventory == null && !(list = worldIn.func_175674_a((Entity)null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelectors.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(worldIn.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.func_190916_E() > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

