/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.tiles;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import primal_tech.blocks.BlockWaterSaw;
import primal_tech.recipes.WaterSawRecipes;
import primal_tech.tiles.TileEntityInventoryHelper;

public class TileEntityWaterSaw
extends TileEntityInventoryHelper
implements ITickable {
    private IItemHandler itemHandler;
    private static final int[] SLOTS = new int[]{0};
    public boolean active;
    public int animationTicks;
    public int prevAnimationTicks;
    public int progress;

    public TileEntityWaterSaw() {
        super(1);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K && this.getActive()) {
            this.prevAnimationTicks = this.animationTicks;
            if (this.animationTicks < 360) {
                this.animationTicks += 10;
            }
            if (this.animationTicks >= 360) {
                this.animationTicks -= 360;
                this.prevAnimationTicks -= 360;
            }
        }
        if (this.func_145831_w().field_72995_K && !this.getActive()) {
            this.prevAnimationTicks = this.animationTicks;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.func_145831_w().func_180495_p(this.field_174879_c) != null && this.getActive() && !((ItemStack)this.getItems().get(0)).func_190926_b() && this.getChoppingTime() != 0) {
                ItemStack output;
                this.setChoppingProgress(this.getChoppingProgress() + 1);
                if (this.getChoppingProgress() % 5 == 0) {
                    this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_187613_bi, SoundCategory.BLOCKS, 0.25f, 0.5f);
                }
                if (this.getChoppingProgress() >= this.getChoppingTime() && !(output = WaterSawRecipes.getOutput((ItemStack)this.getItems().get(0))).func_190926_b() && output != this.getItems().get(0)) {
                    ((ItemStack)this.getItems().get(0)).func_190918_g(1);
                    TileEntityWaterSaw.spawnItemStack(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                    this.setChoppingProgress(0);
                }
            }
            if (this.func_145831_w().func_82737_E() % 10L == 0L) {
                if (!this.getActive() && this.getWaterFlow(this.func_145831_w().func_180495_p(this.field_174879_c))) {
                    this.setActive(true);
                }
                if (this.getActive() && !this.getWaterFlow(this.func_145831_w().func_180495_p(this.field_174879_c))) {
                    this.setActive(false);
                }
            }
        }
    }

    private boolean getWaterFlow(IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockWaterSaw.FACING);
        IBlockState blockBelow = this.func_145831_w().func_180495_p(this.field_174879_c.func_177977_b());
        IBlockState blockBelowBack = this.func_145831_w().func_180495_p(this.field_174879_c.func_177977_b().func_177972_a(enumfacing.func_176734_d()));
        return blockBelow.func_177230_c() == Blocks.field_150355_j && blockBelow.func_177230_c().func_176201_c(blockBelow) == 0 && blockBelowBack.func_177230_c() == Blocks.field_150355_j && blockBelowBack.func_177230_c().func_176201_c(blockBelowBack) == 1;
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        entityitem.func_174867_a(40);
        world.func_72838_d((Entity)entityitem);
    }

    public void setChoppingProgress(int choppingProgress) {
        this.progress = choppingProgress;
        this.markForUpdate();
    }

    public int getChoppingProgress() {
        return this.progress;
    }

    public int getChoppingTime() {
        return WaterSawRecipes.getChopTime((ItemStack)this.getItems().get(0));
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.markForUpdate();
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.active = nbt.func_74767_n("active");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    @Override
    public void func_70299_a(int index, @Nullable ItemStack stack) {
        super.func_70299_a(index, stack);
        this.markForUpdate();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

