/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.item.ItemStack;
import primal_tech.ModBlocks;
import primal_tech.jei.clay_kiln.KilnCategory;
import primal_tech.jei.clay_kiln.KilnRecipeHandler;
import primal_tech.jei.clay_kiln.KilnRecipeWrapper;
import primal_tech.recipes.ClayKilnRecipes;

@JEIPlugin
public class JEIPlugInClayKiln
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IIngredientRegistry ingredientRegistry = registry.getIngredientRegistry();
        registry.addRecipeCategories(new IRecipeCategory[]{new KilnCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new KilnRecipeHandler()});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.CLAY_KILN), new String[]{"primal_tech.clay_kiln_recipes"});
        List<KilnRecipeWrapper> recipes = new ArrayList<KilnRecipeWrapper>();
        recipes = this.getTestRecipe(recipes);
        registry.addRecipes(recipes);
    }

    private List<KilnRecipeWrapper> getTestRecipe(List<KilnRecipeWrapper> recipes) {
        for (ClayKilnRecipes recipe : ClayKilnRecipes.getRecipeList()) {
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            ItemStack inStack = recipe.getInput();
            ItemStack outStack = ClayKilnRecipes.getOutput(inStack);
            ItemStack outStack2 = new ItemStack(ModBlocks.CLAY_KILN);
            output.add(outStack);
            output.add(outStack2);
            recipes.add(new KilnRecipeWrapper(inStack, output));
        }
        return recipes;
    }

    public void onRuntimeAvailable(IJeiRuntime arg0) {
    }

    public void registerIngredients(IModIngredientRegistration arg0) {
    }

    public void registerItemSubtypes(ISubtypeRegistry arg0) {
    }
}

