/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primal_tech.PrimalTech;
import primal_tech.tiles.TileEntityWoodenHopper;

public class BlockWoodenHopper
extends BlockDirectional
implements ITileEntityProvider {
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockWoodenHopper() {
        super(Material.field_151575_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(PrimalTech.TAB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.func_176734_d();
        if (enumfacing == EnumFacing.UP) {
            enumfacing = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)enumfacing).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityWoodenHopper();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        ((TileEntityWoodenHopper)world.func_175625_s((BlockPos)pos)).rotation = direction == EnumFacing.DOWN ? (byte)1 : (byte)(((MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 1) % 4);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        ItemStack stack = player.func_184614_ca();
        if (world.func_175625_s(pos) instanceof TileEntityWoodenHopper) {
            TileEntityWoodenHopper tile = (TileEntityWoodenHopper)world.func_175625_s(pos);
            if (side.func_176745_a() == 1) {
                int slotClicked = this.getSlotClicked(direction, hitX, hitZ);
                if (!player.func_70093_af()) {
                    if (!stack.func_190926_b() && (tile.func_70301_a(slotClicked).func_190926_b() || tile.func_70301_a(slotClicked).func_77973_b() == stack.func_77973_b() && tile.func_70301_a(slotClicked).func_77952_i() == stack.func_77952_i() && tile.func_70301_a(slotClicked).func_190916_E() < 64 && tile.func_70301_a(slotClicked).func_77985_e()) && !world.field_72995_K) {
                        if (!tile.func_70301_a(slotClicked).func_190926_b()) {
                            tile.func_70301_a(slotClicked).func_190917_f(1);
                            stack.func_190918_g(1);
                        } else {
                            tile.func_70299_a(slotClicked, stack.func_77979_a(1));
                        }
                        tile.markForUpdate();
                        return true;
                    }
                } else {
                    ItemStack stack2 = tile.func_70301_a(slotClicked);
                    if (!stack2.func_190926_b()) {
                        if (!player.field_71071_by.func_70441_a(stack2)) {
                            ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)stack2, (boolean)false);
                        }
                        tile.func_70299_a(slotClicked, stack2.func_77979_a(1));
                        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                    }
                    tile.markForUpdate();
                    return true;
                }
            }
        }
        return true;
    }

    public int getSlotClicked(EnumFacing direction, float hitX, float hitZ) {
        int slot = 3;
        if (hitX > 0.0f && hitX < 0.5f && hitZ > 0.0f && hitZ < 0.5f) {
            if (direction == EnumFacing.NORTH) {
                slot = 0;
            }
            if (direction == EnumFacing.EAST) {
                slot = 2;
            }
            if (direction == EnumFacing.WEST) {
                slot = 1;
            }
            if (direction == EnumFacing.SOUTH || direction == EnumFacing.DOWN) {
                slot = 3;
            }
        }
        if (hitX > 0.5f && hitX < 1.0f && hitZ > 0.0f && hitZ < 0.5f) {
            if (direction == EnumFacing.NORTH) {
                slot = 1;
            }
            if (direction == EnumFacing.EAST) {
                slot = 0;
            }
            if (direction == EnumFacing.WEST) {
                slot = 3;
            }
            if (direction == EnumFacing.SOUTH || direction == EnumFacing.DOWN) {
                slot = 2;
            }
        }
        if (hitX > 0.0f && hitX < 0.5f && hitZ > 0.5f && hitZ < 1.0f) {
            if (direction == EnumFacing.NORTH) {
                slot = 2;
            }
            if (direction == EnumFacing.EAST) {
                slot = 3;
            }
            if (direction == EnumFacing.WEST) {
                slot = 0;
            }
            if (direction == EnumFacing.SOUTH || direction == EnumFacing.DOWN) {
                slot = 1;
            }
        }
        if (hitX > 0.5f && hitX <= 1.0f && hitZ > 0.5f && hitZ < 1.0f) {
            if (direction == EnumFacing.NORTH) {
                slot = 3;
            }
            if (direction == EnumFacing.EAST) {
                slot = 1;
            }
            if (direction == EnumFacing.WEST) {
                slot = 2;
            }
            if (direction == EnumFacing.SOUTH || direction == EnumFacing.DOWN) {
                slot = 0;
            }
        }
        return slot;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateState(world, pos, state);
    }

    private void updateState(World world, BlockPos pos, IBlockState state) {
        boolean flag;
        boolean bl = flag = !world.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityWoodenHopper) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityWoodenHopper)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    public static boolean isEnabled(int meta) {
        return (meta & 8) != 8;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)BlockWoodenHopper.getFacing(meta)).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(BlockWoodenHopper.isEnabled(meta)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
        if (!((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, ENABLED});
    }
}

