/*
 * Decompiled with CFR 0.152.
 */
package primal_tech;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import primal_tech.ModBlocks;
import primal_tech.ModItems;
import primal_tech.configs.ConfigHandler;
import primal_tech.events.EntityBoneShardEvent;
import primal_tech.events.TorchLightEvent;
import primal_tech.network.FireSticksMessage;
import primal_tech.network.FireSticksPacketHandler;
import primal_tech.proxy.CommonProxy;
import primal_tech.recipes.ModRecipes;

@Mod(modid="primal_tech", name="primal_tech", version="0.3.5", guiFactory="primal_tech.configs.ConfigGuiFactory", dependencies="after:*", acceptedMinecraftVersions="[1.12.2]")
public class PrimalTech {
    @Mod.Instance(value="primal_tech")
    public static PrimalTech INSTANCE;
    @SidedProxy(clientSide="primal_tech.proxy.ClientProxy", serverSide="primal_tech.proxy.CommonProxy")
    public static CommonProxy PROXY;
    public static Item.ToolMaterial TOOL_BONE;
    public static Item.ToolMaterial TOOL_BONE_KNIFE;
    public static SimpleNetworkWrapper NETWORK_WRAPPER;
    public static CreativeTabs TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        GameRegistry.registerFuelHandler((IFuelHandler)new IFuelHandler(){

            public int getBurnTime(ItemStack fuel) {
                if (fuel.func_77973_b() == Item.func_150898_a((Block)ModBlocks.CHARCOAL_BLOCK)) {
                    return 6400;
                }
                return 0;
            }
        });
        PROXY.registerTileEntities();
        PROXY.registerRenderers();
        NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("primal_tech");
        NETWORK_WRAPPER.registerMessage(FireSticksPacketHandler.class, FireSticksMessage.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModRecipes.addKilnRecipes();
        ModRecipes.addWaterSawRecipes();
        ModRecipes.addStoneAnvilRecipes();
        ModRecipes.addWoodenBasinRecipes();
        MinecraftForge.EVENT_BUS.register((Object)new TorchLightEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntityBoneShardEvent());
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit();
    }

    static {
        TOOL_BONE = EnumHelper.addToolMaterial((String)"BONE_TOOLS", (int)1, (int)100, (float)5.0f, (float)0.0f, (int)15);
        TOOL_BONE_KNIFE = EnumHelper.addToolMaterial((String)"BONE_KNIFE", (int)0, (int)10, (float)2.0f, (float)0.0f, (int)0);
        TAB = new CreativeTabs("primal_tech"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ModItems.BONE_KNIFE);
            }
        };
        FluidRegistry.enableUniversalBucket();
    }
}

