/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.util;

import com.bloodnbonesgaming.bnbgamingcore.core.BNBGamingCorePlugin;
import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.module.ModulePerformAdditions;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;

public abstract class BNBGamingClassTransformer
implements IClassTransformer {
    private static final List<BNBGamingClassTransformer> transformers = Lists.newArrayList();
    private static final Map<BNBGamingClassTransformer, List<IClassTransformerModule>> transformerModules = new IdentityHashMap<BNBGamingClassTransformer, List<IClassTransformerModule>>();

    public BNBGamingClassTransformer() {
        transformers.add(this);
        List<IClassTransformerModule> transformerModules = this.createModules();
        if (transformerModules != null) {
            ASMAdditionRegistry.ASMAdditionRegistryWrapper regWrapper = ASMAdditionRegistry.getWrapper(this.getName());
            for (IClassTransformerModule module : transformerModules) {
                BNBGamingClassTransformer.registerTransformerModule(this, module);
                module.registerAdditions(regWrapper);
            }
        }
    }

    public abstract List<IClassTransformerModule> createModules();

    public abstract String getName();

    public abstract void setAdditionHelper(ASMAdditionHelper var1);

    public static void registerTransformerModule(BNBGamingClassTransformer owner, IClassTransformerModule transformerModule) {
        if (!transformerModules.containsKey(owner)) {
            transformerModules.put(owner, new ArrayList());
        }
        if (transformerModule instanceof ModulePerformAdditions) {
            transformerModules.get(owner).add(0, transformerModule);
        } else {
            transformerModules.get(owner).add(transformerModule);
        }
    }

    public static void disableTransformerModule(String name) {
        for (List<IClassTransformerModule> list : transformerModules.values()) {
            Iterator<IClassTransformerModule> it = list.iterator();
            while (it.hasNext()) {
                if (!it.next().getModuleName().equals(name)) continue;
                it.remove();
            }
        }
    }

    public static void disableAllTransformerModulesExcept(List<String> names) {
        for (List<IClassTransformerModule> list : transformerModules.values()) {
            Iterator<IClassTransformerModule> it = list.iterator();
            while (it.hasNext()) {
                IClassTransformerModule module = it.next();
                if (!module.canBeDisabled() || names.contains(module.getModuleName())) continue;
                BNBGamingCorePlugin.log.debug("Disabled ASM module " + module.getModuleName());
                it.remove();
            }
        }
    }

    public static IClassTransformerModule[] getTransformerModules() {
        ArrayList<IClassTransformerModule> list = new ArrayList<IClassTransformerModule>();
        for (List<IClassTransformerModule> modules : transformerModules.values()) {
            list.addAll(modules);
        }
        return list.toArray(new IClassTransformerModule[list.size()]);
    }

    public static BNBGamingClassTransformer lookupOwner(IClassTransformerModule module) {
        for (BNBGamingClassTransformer transformer : transformers) {
            if (!transformerModules.get(transformer).contains(module)) continue;
            return transformer;
        }
        return null;
    }

    static List<BNBGamingClassTransformer> getTransformers() {
        return transformers;
    }
}

