/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Arrays;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class TransporterUtils {
    public static List<EnumColor> colors = Arrays.asList(EnumColor.DARK_BLUE, EnumColor.DARK_GREEN, EnumColor.DARK_AQUA, EnumColor.DARK_RED, EnumColor.PURPLE, EnumColor.INDIGO, EnumColor.BRIGHT_GREEN, EnumColor.AQUA, EnumColor.RED, EnumColor.PINK, EnumColor.YELLOW, EnumColor.BLACK);

    public static boolean isValidAcceptorOnSide(TileEntity tile, EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        return InventoryUtils.isItemHandler(tile, side.func_176734_d());
    }

    public static TransitRequest.TransitResponse insert(TileEntity outputter, ILogisticalTransporter transporter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        return transporter.insert(Coord4D.get(outputter), request, color, doEmit, min);
    }

    public static TransitRequest.TransitResponse insertRR(TileEntityLogisticalSorter outputter, ILogisticalTransporter transporter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        return transporter.insertRR(outputter, request, color, doEmit, min);
    }

    public static EnumColor increment(EnumColor color) {
        if (color == null) {
            return colors.get(0);
        }
        if (colors.indexOf((Object)color) == colors.size() - 1) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) + 1);
    }

    public static EnumColor decrement(EnumColor color) {
        if (color == null) {
            return colors.get(colors.size() - 1);
        }
        if (colors.indexOf((Object)color) == 0) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) - 1);
    }

    public static void drop(ILogisticalTransporter tileEntity, TransporterStack stack) {
        float[] pos = stack.hasPath() ? TransporterUtils.getStackPosition(tileEntity, stack, 0.0f) : new float[]{0.0f, 0.0f, 0.0f};
        TransporterManager.remove(stack);
        BlockPos blockPos = new BlockPos((double)((float)tileEntity.coord().x + pos[0]), (double)((float)tileEntity.coord().y + pos[1]), (double)((float)tileEntity.coord().z + pos[2]));
        Block.func_180635_a((World)tileEntity.world(), (BlockPos)blockPos, (ItemStack)stack.itemStack);
    }

    public static float[] getStackPosition(ILogisticalTransporter tileEntity, TransporterStack stack, float partial) {
        EnumFacing side = stack.getSide(tileEntity);
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        return new float[]{0.5f + (float)side.func_82601_c() * progress, 0.25f + (float)side.func_96559_d() * progress, 0.5f + (float)side.func_82599_e() * progress};
    }

    public static void incrementColor(ILogisticalTransporter tileEntity) {
        if (tileEntity.getColor() == null) {
            tileEntity.setColor(colors.get(0));
        } else if (colors.indexOf((Object)tileEntity.getColor()) == colors.size() - 1) {
            tileEntity.setColor(null);
        } else {
            int index = colors.indexOf((Object)tileEntity.getColor());
            tileEntity.setColor(colors.get(index + 1));
        }
    }
}

