/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITileComponent;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileComponentSecurity
implements ITileComponent {
    public TileEntityContainerBlock tileEntity;
    private UUID ownerUUID;
    private String clientOwner;
    private ISecurityTile.SecurityMode securityMode = ISecurityTile.SecurityMode.PUBLIC;
    private SecurityFrequency frequency;

    public TileComponentSecurity(TileEntityContainerBlock tile) {
        this.tileEntity = tile;
        tile.components.add(this);
    }

    public void readFrom(TileComponentSecurity security) {
        this.ownerUUID = security.ownerUUID;
        this.securityMode = security.securityMode;
    }

    public SecurityFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(UUID owner) {
        FrequencyManager manager = Mekanism.securityFrequencies;
        manager.deactivate(Coord4D.get(this.tileEntity));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.ownerUUID.equals(owner)) continue;
            this.frequency = (SecurityFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this.tileEntity));
            return;
        }
        Frequency freq = new SecurityFrequency(owner).setPublic(true);
        freq.activeCoords.add(Coord4D.get(this.tileEntity));
        manager.addFrequency(freq);
        this.frequency = (SecurityFrequency)freq;
        MekanismUtils.saveChunk(this.tileEntity);
        this.tileEntity.func_70296_d();
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.frequency = null;
        this.ownerUUID = uuid;
    }

    public String getClientOwner() {
        return this.clientOwner;
    }

    public ISecurityTile.SecurityMode getMode() {
        if (MekanismConfig.current().general.allowProtection.val()) {
            return this.securityMode;
        }
        return ISecurityTile.SecurityMode.PUBLIC;
    }

    public void setMode(ISecurityTile.SecurityMode mode) {
        this.securityMode = mode;
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.ownerUUID == null || freq == null) {
            return null;
        }
        return Mekanism.securityFrequencies;
    }

    @Override
    public void tick() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            FrequencyManager manager;
            if (this.frequency == null && this.ownerUUID != null) {
                this.setFrequency(this.ownerUUID);
            }
            if ((manager = this.getManager(this.frequency)) != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (SecurityFrequency)manager.validateFrequency(this.ownerUUID, Coord4D.get(this.tileEntity), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = (SecurityFrequency)manager.update(Coord4D.get(this.tileEntity), this.frequency);
                }
            } else {
                this.frequency = null;
            }
        }
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.securityMode = ISecurityTile.SecurityMode.values()[nbtTags.func_74762_e("securityMode")];
        if (nbtTags.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbtTags.func_74779_i("ownerUUID"));
        }
        if (nbtTags.func_74764_b("securityFreq")) {
            this.frequency = new SecurityFrequency(nbtTags.func_74775_l("securityFreq"));
            this.frequency.valid = false;
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.securityMode = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.ownerUUID = UUID.fromString(PacketHandler.readString(dataStream));
            this.clientOwner = PacketHandler.readString(dataStream);
        } else {
            this.ownerUUID = null;
            this.clientOwner = null;
        }
        this.frequency = dataStream.readBoolean() ? new SecurityFrequency(dataStream) : null;
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("securityMode", this.securityMode.ordinal());
        if (this.ownerUUID != null) {
            nbtTags.func_74778_a("ownerUUID", this.ownerUUID.toString());
        }
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("securityFreq", (NBTBase)frequencyTag);
        }
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.securityMode.ordinal());
        if (this.ownerUUID != null) {
            data.add(true);
            data.add(this.ownerUUID.toString());
            data.add(MekanismUtils.getLastKnownUsername(this.ownerUUID));
        } else {
            data.add(false);
        }
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
    }

    @Override
    public void invalidate() {
        FrequencyManager manager;
        if (!this.tileEntity.func_145831_w().field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this.tileEntity));
        }
    }
}

