/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum FluidTankTier implements ITier
{
    BASIC(14000, 400),
    ADVANCED(28000, 800),
    ELITE(56000, 1600),
    ULTIMATE(112000, 3200),
    CREATIVE(Integer.MAX_VALUE, 0x3FFFFFFF);

    private final int baseStorage;
    private final int baseOutput;
    private final BaseTier baseTier;

    private FluidTankTier(int s, int o) {
        this.baseStorage = s;
        this.baseOutput = o;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getStorage() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).FluidTankStorage.val();
    }

    public int getOutput() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).FluidTankOutput.val();
    }

    public int getBaseStorage() {
        return this.baseStorage;
    }

    public int getBaseOutput() {
        return this.baseOutput;
    }
}

