/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemFlamethrower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFlamethrowerData
implements IMessageHandler<FlamethrowerDataMessage, IMessage> {
    public IMessage onMessage(FlamethrowerDataMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            if (message.packetType == FlamethrowerPacket.UPDATE) {
                Mekanism.playerState.setFlamethrowerState(message.uuid, message.value, false);
                if (!player.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(message, player.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == FlamethrowerPacket.MODE) {
                ItemStack stack = player.func_184586_b(message.currentHand);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFlamethrower) {
                    ((ItemFlamethrower)stack.func_77973_b()).incrementMode(stack);
                }
            } else if (message.packetType == FlamethrowerPacket.FULL) {
                Mekanism.playerState.setActiveFlamethrowers(message.activeFlamethrowers);
            }
        }, player);
        return null;
    }

    public static class FlamethrowerDataMessage
    implements IMessage {
        public FlamethrowerPacket packetType;
        protected Set<UUID> activeFlamethrowers;
        public EnumHand currentHand;
        public UUID uuid;
        public boolean value;

        public FlamethrowerDataMessage() {
        }

        public FlamethrowerDataMessage(FlamethrowerPacket type) {
            this.packetType = type;
        }

        public static FlamethrowerDataMessage MODE_CHANGE(EnumHand hand) {
            FlamethrowerDataMessage m = new FlamethrowerDataMessage(FlamethrowerPacket.MODE);
            m.currentHand = hand;
            return m;
        }

        public static FlamethrowerDataMessage UPDATE(UUID uuid, boolean state) {
            FlamethrowerDataMessage m = new FlamethrowerDataMessage(FlamethrowerPacket.UPDATE);
            m.uuid = uuid;
            m.value = state;
            return m;
        }

        public static FlamethrowerDataMessage FULL(Set<UUID> activeNames) {
            FlamethrowerDataMessage m = new FlamethrowerDataMessage(FlamethrowerPacket.FULL);
            m.activeFlamethrowers = activeNames;
            return m;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                PacketHandler.writeUUID(dataStream, this.uuid);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == FlamethrowerPacket.MODE) {
                dataStream.writeInt(this.currentHand.ordinal());
            } else if (this.packetType == FlamethrowerPacket.FULL) {
                dataStream.writeInt(this.activeFlamethrowers.size());
                for (UUID uuid : this.activeFlamethrowers) {
                    PacketHandler.writeUUID(dataStream, uuid);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = FlamethrowerPacket.values()[dataStream.readInt()];
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                this.uuid = PacketHandler.readUUID(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == FlamethrowerPacket.MODE) {
                this.currentHand = EnumHand.values()[dataStream.readInt()];
            } else if (this.packetType == FlamethrowerPacket.FULL) {
                this.activeFlamethrowers = new HashSet<UUID>();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.activeFlamethrowers.add(PacketHandler.readUUID(dataStream));
                }
            }
        }
    }

    public static enum FlamethrowerPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

