/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.tile.tickable.machine;

import com.valkyrieofnight.um.api.inventory.ItemHandlerModifiable;
import com.valkyrieofnight.um.api.modifier.IModifier;
import com.valkyrieofnight.um.modifier.ModifierHandler;
import com.valkyrieofnight.vliblegacy.lib.tile.tickable.VLTileTickableFacing;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class VLTileMachineUpgradable
extends VLTileTickableFacing {
    protected ItemHandlerModifiable modifierSlots;
    protected ModifierHandler modifierHandler;
    int pmtick = 0;

    public VLTileMachineUpgradable(int upgradeSlots) {
        this.modifierSlots = new ItemHandlerModifiable(upgradeSlots);
        this.modifierHandler = new ModifierHandler();
    }

    public ItemHandlerModifiable getItemModifierHandler() {
        return this.modifierSlots;
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        nbt.func_74782_a("modifiers", (NBTBase)this.modifierSlots.serializeNBT());
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.modifierSlots.deserializeNBT(nbt.func_74775_l("modifiers"));
        this.processModifiers();
    }

    @Override
    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.modifierHandler.update();
            ++this.pmtick;
            if (this.modifierSlots.hasChanged() || this.pmtick > 60) {
                this.processModifiers();
                this.markForUpdate();
                this.onSlotsChanged();
                this.pmtick = 0;
            }
        }
    }

    public abstract void onSlotsChanged();

    public void processModifiers() {
        ArrayList<IModifier> mods = new ArrayList<IModifier>();
        for (ItemStack st : this.modifierSlots.getStacks()) {
            int i;
            if (st == ItemStack.field_190927_a) continue;
            if (Block.func_149634_a((Item)st.func_77973_b()) instanceof IModifier) {
                for (i = 0; i < st.func_190916_E(); ++i) {
                    mods.add((IModifier)Block.func_149634_a((Item)st.func_77973_b()));
                }
                continue;
            }
            if (!(st.func_77973_b() instanceof IModifier)) continue;
            for (i = 0; i < st.func_190916_E(); ++i) {
                mods.add((IModifier)st.func_77973_b());
            }
        }
        this.modifierHandler.setModifiers(mods);
        this.modifierHandler.update();
    }
}

