/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.features;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.base.IRegisterModel;
import com.valkyrieofnight.vlib.core.item.color.IItemColored;
import com.valkyrieofnight.vlib.core.registry.VLRegistryClient;
import com.valkyrieofnight.vlib.core.registry.VLRegistryCommon;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.features.FeatureConfigurable;
import com.valkyrieofnight.vlib.module.interfaces.IClientInit;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInit;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterItems;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterModels;
import com.valkyrieofnight.vlib.module.interfaces.IRegisterOre;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class FeatureItems
extends FeatureConfigurable
implements IClientInit,
ICommonInit,
IEventRegisterItems,
IEventRegisterModels {
    private List<Item> ITEMS = Lists.newArrayList();

    public FeatureItems(String id) {
        super(id);
    }

    protected final void addItem(Item item) {
        if (item == null) {
            return;
        }
        this.ITEMS.add(item);
    }

    @Override
    public void registerEventModels(ModelRegistryEvent event, IConfig config) {
        this.ITEMS.forEach(itm -> {
            if (itm instanceof IRegisterModel) {
                ((IRegisterModel)itm).registerModel(event, VLRegistryClient.getInstance());
            }
        });
    }

    @Override
    public void registerEventItems(RegistryEvent.Register<Item> event, IConfig config) {
        IForgeRegistry reg = event.getRegistry();
        this.ITEMS.forEach(itm -> reg.register((IForgeRegistryEntry)itm));
    }

    @Override
    public void commonInit(FMLInitializationEvent event, IConfig config) {
        this.ITEMS.forEach(itm -> {
            if (itm instanceof IRegisterOre) {
                ((IRegisterOre)itm).registerOre(VLRegistryCommon.getInstance());
            }
        });
    }

    @Override
    public void clientInit(FMLInitializationEvent event, IConfig config) {
        this.ITEMS.forEach(itm -> {
            if (itm instanceof IItemColored) {
                IItemColored iic = (IItemColored)itm;
                VLRegistryClient.registerColoredItem(itm);
            }
        });
    }
}

