/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.ItemNBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class Frequency
implements Copyable<Frequency> {
    public EnumColour left;
    public EnumColour middle;
    public EnumColour right;
    public String owner;

    public Frequency() {
        this(EnumColour.WHITE, EnumColour.WHITE, EnumColour.WHITE);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right) {
        this(left, middle, right, null);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right, String owner) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.owner = owner;
    }

    public Frequency(NBTTagCompound tagCompound) {
        this.read_internal(tagCompound);
    }

    public static Frequency fromString(String left, String middle, String right) {
        return Frequency.fromString(left, middle, right, null);
    }

    public static Frequency fromString(String left, String middle, String right, String owner) {
        EnumColour c1 = EnumColour.fromName((String)left);
        EnumColour c2 = EnumColour.fromName((String)middle);
        EnumColour c3 = EnumColour.fromName((String)right);
        if (c1 == null) {
            throw new RuntimeException(left + " is an invalid colour!");
        }
        if (c2 == null) {
            throw new RuntimeException(middle + " is an invalid colour!");
        }
        if (c3 == null) {
            throw new RuntimeException(right + " is an invalid colour!");
        }
        return new Frequency(c1, c2, c3, owner);
    }

    public Frequency setLeft(EnumColour left) {
        if (left != null) {
            this.left = left;
        }
        return this;
    }

    public Frequency setMiddle(EnumColour middle) {
        if (middle != null) {
            this.middle = middle;
        }
        return this;
    }

    public Frequency setRight(EnumColour right) {
        if (right != null) {
            this.right = right;
        }
        return this;
    }

    public Frequency setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public Frequency set(EnumColour[] colours) {
        this.setLeft(colours[0]);
        this.setMiddle(colours[1]);
        this.setRight(colours[2]);
        return this;
    }

    public Frequency set(Frequency frequency) {
        this.setLeft(frequency.left);
        this.setMiddle(frequency.middle);
        this.setRight(frequency.right);
        this.setOwner(frequency.owner);
        return this;
    }

    public EnumColour getLeft() {
        return this.left;
    }

    public EnumColour getMiddle() {
        return this.middle;
    }

    public EnumColour getRight() {
        return this.right;
    }

    public EnumColour[] toArray() {
        return new EnumColour[]{this.left, this.middle, this.right};
    }

    protected Frequency read_internal(NBTTagCompound tagCompound) {
        this.left = EnumColour.fromWoolMeta((int)tagCompound.func_74762_e("left"));
        this.middle = EnumColour.fromWoolMeta((int)tagCompound.func_74762_e("middle"));
        this.right = EnumColour.fromWoolMeta((int)tagCompound.func_74762_e("right"));
        if (tagCompound.func_74764_b("owner")) {
            this.owner = tagCompound.func_74779_i("owner");
        }
        return this;
    }

    protected NBTTagCompound write_internal(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("left", this.left.getWoolMeta());
        tagCompound.func_74768_a("middle", this.middle.getWoolMeta());
        tagCompound.func_74768_a("right", this.right.getWoolMeta());
        if (this.owner != null) {
            tagCompound.func_74778_a("owner", this.owner);
        }
        return tagCompound;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        this.write_internal(tagCompound);
        return tagCompound;
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeNBTTagCompound(this.write_internal(new NBTTagCompound()));
    }

    public static Frequency readFromPacket(MCDataInput packet) {
        return new Frequency(packet.readNBTTagCompound());
    }

    public static Frequency readFromStack(ItemStack stack) {
        NBTTagCompound stackTag;
        if (stack.func_77942_o() && (stackTag = stack.func_77978_p()).func_74764_b("Frequency")) {
            return new Frequency(stackTag.func_74775_l("Frequency"));
        }
        return new Frequency();
    }

    public ItemStack writeToStack(ItemStack stack) {
        NBTTagCompound tagCompound = ItemNBTUtils.validateTagExists((ItemStack)stack);
        tagCompound.func_74782_a("Frequency", (NBTBase)this.write_internal(new NBTTagCompound()));
        return stack;
    }

    public String toModelLoc() {
        return "left=" + this.getLeft().func_176610_l() + ",middle=" + this.getMiddle().func_176610_l() + ",right=" + this.getRight().func_176610_l() + ",owned=" + this.hasOwner();
    }

    public String toString() {
        String owner = "";
        if (this.hasOwner()) {
            owner = ",owner=" + this.owner;
        }
        return "left=" + this.getLeft().func_176610_l() + ",middle=" + this.getMiddle().func_176610_l() + ",right=" + this.getRight().func_176610_l() + owner;
    }

    public String getTooltip() {
        return String.format("%s/%s/%s", this.getLeft().getLocalizedName(), this.getMiddle().getLocalizedName(), this.getRight().getLocalizedName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Frequency copy() {
        return new Frequency(this.left, this.middle, this.right, this.owner);
    }
}

