/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.texture.GrassInfo;
import mods.octarinecore.client.render.HSB;
import mods.octarinecore.client.resource.ModelRenderKey;
import mods.octarinecore.client.resource.Utils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lmods/betterfoliage/client/texture/StandardGrassKey;", "Lmods/octarinecore/client/resource/ModelRenderKey;", "Lmods/betterfoliage/client/texture/GrassInfo;", "logger", "Lorg/apache/logging/log4j/Logger;", "textureName", "", "(Lorg/apache/logging/log4j/Logger;Ljava/lang/String;)V", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "getTextureName", "()Ljava/lang/String;", "resolveSprites", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "BetterFoliage-MC1.12"})
public final class StandardGrassKey
implements ModelRenderKey<GrassInfo> {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String textureName;

    @Override
    @NotNull
    public GrassInfo resolveSprites(@NotNull TextureMap atlas) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)atlas, (String)"atlas");
        String logName = "StandardGrassKey";
        TextureAtlasSprite textureAtlasSprite = Utils.get(atlas, this.textureName);
        if (textureAtlasSprite == null) {
            textureAtlasSprite = atlas.func_174944_f();
        }
        TextureAtlasSprite texture = textureAtlasSprite;
        this.getLogger().log(Level.DEBUG, logName + ": texture " + this.textureName);
        TextureAtlasSprite textureAtlasSprite2 = texture;
        Intrinsics.checkExpressionValueIsNotNull((Object)textureAtlasSprite2, (String)"texture");
        Integer n2 = Utils.getAverageColor(textureAtlasSprite2);
        HSB hsb = HSB.Companion.fromColor(n2 != null ? n2 : 0);
        if ((double)hsb.getSaturation() >= Config.shortGrass.INSTANCE.getSaturationThreshold()) {
            this.getLogger().log(Level.DEBUG, logName + ":         brightness " + hsb.getBrightness());
            this.getLogger().log(Level.DEBUG, logName + ":         saturation " + hsb.getSaturation() + " >= " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using texture color");
            n = HSB.copy$default(hsb, 0.0f, 0.0f, Math.min(0.9f, hsb.getBrightness() * 2.0f), 3, null).getAsColor();
        } else {
            this.getLogger().log(Level.DEBUG, logName + ":         saturation " + hsb.getSaturation() + " < " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using block color");
            n = null;
        }
        Integer overrideColor = n;
        return new GrassInfo(texture, overrideColor);
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getTextureName() {
        return this.textureName;
    }

    public StandardGrassKey(@NotNull Logger logger, @NotNull String textureName) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)textureName, (String)"textureName");
        this.logger = logger;
        this.textureName = textureName;
    }

    @Override
    public void onPreStitch(@NotNull TextureMap atlas) {
        Intrinsics.checkParameterIsNotNull((Object)atlas, (String)"atlas");
        ModelRenderKey.DefaultImpls.onPreStitch(this, atlas);
    }
}

