/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.utils;

import com.gendeathrow.mputils.configs.ConfigHandler;
import com.gendeathrow.mputils.core.MPUtils;
import com.gendeathrow.mputils.utils.NBTJSONConverter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Tools {
    public static final String UTF8_BOM = "\ufeff";

    public static InputStreamReader HttpRequest() throws IOException {
        String stringUrl = "https://api.twitch.tv/kraken/search/streams?q=starcraft";
        URL url = new URL(stringUrl);
        URLConnection uc = url.openConnection();
        uc.setRequestProperty("application/vnd.twitchtv.v3+json", "Accept");
        InputStreamReader inputStreamReader = new InputStreamReader(uc.getInputStream());
        return inputStreamReader;
    }

    public static List<Class> getAllSuperclasses(Class cls) {
        ArrayList<Class> res = new ArrayList<Class>();
        while ((cls = cls.getSuperclass()) != null) {
            res.add(cls);
        }
        return res;
    }

    public static void DownloadFile(String url, String fileName) throws IOException {
        URL link = new URL(url);
        BufferedInputStream in = new BufferedInputStream(link.openStream());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while (-1 != (n = ((InputStream)in).read(buf))) {
            out.write(buf, 0, n);
        }
        out.close();
        ((InputStream)in).close();
        byte[] response = out.toByteArray();
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(response);
        fos.close();
    }

    public static void CopyandPasteResourceToFile(InputStream ddlStream, String outputUrl) throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(outputUrl);){
            int r;
            byte[] buf = new byte[2048];
            while (-1 != (r = ddlStream.read(buf))) {
                fos.write(buf, 0, r);
            }
        }
    }

    public static String URLReader(String urlString) throws Exception {
        String inputLine;
        String string = "";
        URL url = new URL(urlString);
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        while ((inputLine = in.readLine()) != null) {
            string = string + inputLine + ConfigHandler.NEW_LINE;
        }
        in.close();
        return Tools.removeUTF8BOM(string);
    }

    private static String removeUTF8BOM(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }

    public static File lastFileModified(String dir) {
        File fl = new File(dir);
        File[] files = fl.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File choice = null;
        for (File file : files) {
            if (file.lastModified() <= lastMod) continue;
            choice = file;
            lastMod = file.lastModified();
        }
        return choice;
    }

    public static String sendJsonHttpPost(String url, JsonObject postData) throws IOException {
        URL object = new URL(url);
        HttpURLConnection con = (HttpURLConnection)object.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestMethod("POST");
        con.getOutputStream().write(postData.toString().getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line + "\n");
        }
        con.connect();
        return stringBuilder.toString();
    }

    public static void sendpost() throws IOException {
        URL object = new URL("http://logs-01.loggly.com/inputs/a522e114-193a-4518-ae3e-10a2732bc9f3/tag/http/");
        HttpURLConnection con = (HttpURLConnection)object.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "content-type:text/plain");
        con.setRequestMethod("POST");
        String hello = "hello";
        con.getOutputStream().write(hello.getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line + "\n");
        }
        con.connect();
    }

    public static String createGist(String filename, String data, String title) throws IOException {
        URL object = new URL("https://api.github.com/gists");
        Gson gson = new Gson();
        HttpURLConnection con = (HttpURLConnection)object.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/vnd.github.v3+json");
        con.setRequestMethod("POST");
        JsonObject payload = new JsonObject();
        payload.addProperty("description", "CrashLog MPUtils: " + title);
        payload.addProperty("public", Boolean.valueOf(true));
        JsonObject files = new JsonObject();
        JsonObject sendfile = new JsonObject();
        sendfile.addProperty("content", data);
        files.add(filename, (JsonElement)sendfile);
        payload.add("files", (JsonElement)files);
        con.getOutputStream().write(payload.toString().getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line + "\n");
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject json = jsonParser.parse(stringBuilder.toString()).getAsJsonObject();
        con.connect();
        if (json.has("html_url")) {
            return json.get("html_url").getAsString();
        }
        return line;
    }

    public static boolean CopytoClipbard(String string) {
        try {
            StringSelection selection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            return true;
        }
        catch (Exception e) {
            MPUtils.logger.log(Level.ERROR, (Object)e);
            return false;
        }
    }

    public static String getItemInfo(String[] args, String itemID, ItemStack stack) {
        String ore = "";
        String nbt = "";
        if (args.length > 1) {
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            for (String arg : args) {
                if (arg.toLowerCase().trim().equals("<>") && !flag1) {
                    itemID = "<" + itemID + ">";
                    flag1 = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equals("ore") && !flag2) {
                    ore = ore + " Ores:[";
                    boolean f = false;
                    for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                        ore = ore + (!f ? " ore:" : " | ore:") + OreDictionary.getOreName((int)id);
                        f = true;
                    }
                    ore = ore + "]";
                    flag2 = true;
                    continue;
                }
                if (!arg.toLowerCase().trim().equals("nbt") || flag3) continue;
                NBTTagCompound nbtdata = stack.func_77978_p();
                nbt = nbt + " NBT:";
                nbt = nbtdata != null ? nbt + " " + new GsonBuilder().create().toJson((JsonElement)NBTJSONConverter.NBTtoJSON_Compound(nbtdata, new JsonObject())) : nbt + " {NBT Null}";
                flag3 = true;
            }
        }
        return itemID + ore + nbt + ConfigHandler.NEW_LINE;
    }

    public static void popUpError(String msg, String msgpop, Logger logger) {
        JFrame parent = new JFrame();
        parent.setSize(400, 400);
        JOptionPane.showMessageDialog(parent, msgpop, "Incompatible Error", 0);
        logger.log(Level.ERROR, msg);
    }
}

