/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.configs;

import com.gendeathrow.mputils.core.MPUtils;
import com.gendeathrow.mputils.core.Settings;
import com.gendeathrow.mputils.utils.MPInfo;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    public static final File configDir = new File("config/mputils");
    public static final File configFile = new File(configDir, "mputils.cfg");
    public static final File addonDir = new File(configDir + "/addons/");
    public static Configuration config;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String NEW_LINE;
    public static final String ConfigVer = "1.0.1";
    private static final String tabMenuCat = "menu_tabs";
    private static final String changelogCat = "changeLog_settings";

    public static void load() {
        config = new Configuration(configFile, ConfigVer);
        ConfigHandler.loadConfiguration();
        MPInfo.LoadMPInfo();
    }

    private static void preLoad() {
        if (config.getLoadedConfigVersion() != config.getDefinedConfigVersion()) {
            ConfigHandler.loadLegacyConfig(config.getLoadedConfigVersion());
            MPUtils.logger.log(Level.INFO, "Config is ");
            configFile.delete();
        }
    }

    public static void loadConfiguration() {
        config.load();
        Settings.useMPInfo = config.getBoolean("Use MPInfo", "general", false, "Set to true, Will create a \"mpinfo.info\" file to input modpack data");
        Settings.editMode = config.getBoolean("Edit Mode", "general", false, "Edit mode opens up a set of new tools to use with MPUtils and its addons.");
        config.save();
    }

    private static void loadLegacyConfig(String version) {
    }

    static {
        NEW_LINE = System.getProperty("line.separator");
    }
}

