/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.commands.client;

import com.gendeathrow.mputils.commands.MP_BaseCommand;
import com.gendeathrow.mputils.configs.ConfigHandler;
import com.gendeathrow.mputils.utils.MTNBTConverter;
import com.gendeathrow.mputils.utils.Tools;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class MP_ItemDump
extends MP_BaseCommand {
    ArrayList options = new ArrayList<String>(Arrays.asList("ore", "nbt", "setPretty", "class", "extendedClass", "<>", "onlyhasrecipes"));
    boolean isSilent = false;
    boolean useParser = false;

    @Override
    public boolean validArgs(String[] args) {
        return true;
    }

    @Override
    public String getUsageSuffix() {
        return " [Args:(nbt, ore, setPretty, class, extendedClass, <>, onlyhasrecipes)]";
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length >= 1) {
            return this.options;
        }
        return new ArrayList<String>();
    }

    public String parseStackData(ICommandSender sender, String[] args, ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) {
            return "";
        }
        ArrayList<String> printout = new ArrayList<String>();
        String returnback = MP_ItemDump.parserItemstack(args, stack, printout);
        if (!this.isSilent) {
            for (String print : printout) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(print, new Object[0]));
            }
        }
        return returnback;
    }

    @Override
    public String getCommand() {
        return null;
    }

    @Override
    public void runCommand(CommandBase command, MinecraftServer server, ICommandSender sender, String[] args) {
    }

    public static String parserItemstack(String[] args, ItemStack stack, List<String> printout) {
        String itemID = stack.func_77973_b().getRegistryName() + (stack.func_77952_i() != 0 ? ":" + stack.func_77952_i() : "");
        String ore = "";
        String clazz = "";
        String extend = "";
        String nbt = "";
        String nbtPretty = "";
        boolean isPretty = false;
        String formatString = "";
        String format = "";
        String returnback = "";
        boolean recipeFlag = false;
        boolean hasRecipe = false;
        printout.add(itemID);
        if (args.length > 1) {
            String completeCommand = "";
            for (String arg : args) {
                completeCommand = completeCommand + " " + arg;
            }
            boolean carretFlag = false;
            boolean oreFlag = false;
            boolean nbtflag = false;
            boolean classFlag = false;
            boolean extendFlag = false;
            boolean parseFlag = false;
            boolean skipFlag = false;
            for (String arg : args) {
                if (!arg.toLowerCase().trim().equals("setpretty")) continue;
                isPretty = true;
            }
            block2: for (String arg : args) {
                if (arg.toLowerCase().trim().equals("<>") && !carretFlag && !skipFlag) {
                    itemID = "<" + itemID + ">";
                    carretFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equalsIgnoreCase("ore") && !oreFlag && !skipFlag) {
                    ore = ore + " Ores:[";
                    boolean f = false;
                    for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                        ore = ore + (!f ? " ore:" : " | ore:") + OreDictionary.getOreName((int)id) + (isPretty ? ConfigHandler.NEW_LINE : ",");
                        printout.add("     <ore:" + OreDictionary.getOreName((int)id) + ">");
                        f = true;
                    }
                    ore = ore + "]";
                    oreFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equals("extendedclass") && !extendFlag && !skipFlag) {
                    List<Class> extendedClasses = Tools.getAllSuperclasses(stack.func_77973_b().getClass());
                    extend = extend + " Extended Classes:[";
                    Object object = extendedClasses.iterator();
                    while (object.hasNext()) {
                        Class extendClass = (Class)object.next();
                        extend = extend + extendClass.getCanonicalName() + (isPretty ? ConfigHandler.NEW_LINE : ",");
                    }
                    extend = extend + "]";
                    printout.add("Extends " + extendedClasses.size() + "x classes (more info on clipboard)");
                    extendFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equals("class") && !classFlag && !skipFlag) {
                    clazz = clazz + " Class: ";
                    clazz = clazz + stack.func_77973_b().getClass().getCanonicalName();
                    printout.add("Class: " + stack.func_77973_b().getClass().getCanonicalName());
                    classFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equals("nbt") && !nbtflag && !skipFlag) {
                    NBTTagCompound nbtdata = stack.func_77978_p();
                    if (nbtdata != null) {
                        nbt = nbt + ".withTag(";
                        GsonBuilder gson = new GsonBuilder();
                        gson.setPrettyPrinting();
                        printout.add("NBT Data Found");
                        nbt = Loader.isModLoaded((String)"crafttweaker") ? nbt + MTNBTConverter.from((NBTBase)nbtdata, false).toString() + ")" : nbt + nbtdata.toString() + ")";
                    }
                    nbtflag = true;
                    continue;
                }
                if (!arg.toLowerCase().trim().equals("onlyhasrecipes") || recipeFlag) continue;
                recipeFlag = true;
                for (IRecipe recipe : CraftingManager.field_193380_a) {
                    if (recipe.func_77571_b().func_77973_b() != stack.func_77973_b() || recipe.func_77571_b().func_77952_i() != stack.func_77952_i()) continue;
                    hasRecipe = true;
                    continue block2;
                }
            }
        }
        if (recipeFlag && !hasRecipe) {
            return "";
        }
        if (isPretty) {
            returnback = "-------------------------------------" + ConfigHandler.NEW_LINE;
            returnback = returnback + "ItemID: " + itemID + ConfigHandler.NEW_LINE;
            returnback = returnback + ore + ConfigHandler.NEW_LINE;
            returnback = returnback + clazz + ConfigHandler.NEW_LINE;
            returnback = returnback + extend + ConfigHandler.NEW_LINE;
            returnback = returnback + "NBTData: " + nbt + ConfigHandler.NEW_LINE;
        } else {
            returnback = itemID + nbt + ore + clazz + extend + ConfigHandler.NEW_LINE;
        }
        return returnback;
    }
}

