/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventTooltip {
    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        String tooltip = null;
        if (!NutrientUtils.isValidFood(itemStack)) {
            return;
        }
        StringJoiner stringJoiner = new StringJoiner(", ");
        List<Nutrient> foundNutrients = NutrientUtils.getFoodNutrients(itemStack);
        for (Nutrient nutrient : foundNutrients) {
            if (!nutrient.visible) continue;
            stringJoiner.add(I18n.func_135052_a((String)("nutrient.nutrition:" + nutrient.name), (Object[])new Object[0]));
        }
        String nutrientString = stringJoiner.toString();
        float nutritionValue = NutrientUtils.calculateNutrition(itemStack, foundNutrients);
        if (!nutrientString.equals("")) {
            tooltip = I18n.func_135052_a((String)"tooltip.nutrition:nutrients", (Object[])new Object[0]) + " " + TextFormatting.DARK_GREEN + nutrientString + TextFormatting.DARK_AQUA + " (" + String.format("%.1f", Float.valueOf(nutritionValue)) + "%)";
        }
        if (tooltip != null) {
            event.getToolTip().add(tooltip);
        }
    }
}

