/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.utility.Config;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventPlayerDeath {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        INutrientManager nutritionOld = (INutrientManager)event.getOriginal().getCapability(NUTRITION_CAPABILITY, null);
        INutrientManager nutritionNew = (INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null);
        nutritionNew.set(nutritionOld.get());
        if (event.isWasDeath()) {
            Map<Nutrient, Float> nutrition = ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).get();
            for (Nutrient nutrient : nutrition.keySet()) {
                if (!Config.deathPenaltyReset && !(nutrition.get(nutrient).floatValue() > (float)Config.deathPenaltyMin)) continue;
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).set(nutrient, Float.valueOf(Math.max((float)Config.deathPenaltyMin, nutrition.get(nutrient).floatValue() - (float)Config.deathPenaltyLoss)));
            }
        }
    }
}

