/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.capabilities;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.capabilities.SimpleImpl;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Config;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityManager {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;

    public static void register() {
        net.minecraftforge.common.capabilities.CapabilityManager.INSTANCE.register(INutrientManager.class, (Capability.IStorage)new Storage(), SimpleImpl::new);
    }

    public static class Storage
    implements Capability.IStorage<INutrientManager> {
        public NBTBase writeNBT(Capability<INutrientManager> capability, INutrientManager instance, EnumFacing side) {
            NBTTagCompound playerData = new NBTTagCompound();
            for (Nutrient nutrient : NutrientList.get()) {
                if (instance.get(nutrient) == null) continue;
                playerData.func_74776_a(nutrient.name, instance.get(nutrient).floatValue());
            }
            return playerData;
        }

        public void readNBT(Capability<INutrientManager> capability, INutrientManager instance, EnumFacing side, NBTBase nbt) {
            HashMap<Nutrient, Float> clientNutrients = new HashMap<Nutrient, Float>();
            for (Nutrient nutrient : NutrientList.get()) {
                float value = ((NBTTagCompound)nbt).func_74764_b(nutrient.name) ? ((NBTTagCompound)nbt).func_74760_g(nutrient.name) : (float)Config.startingNutrition;
                clientNutrients.put(nutrient, Float.valueOf(value));
            }
            instance.set(clientNutrients);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private INutrientManager instance = new SimpleImpl();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == NUTRITION_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == NUTRITION_CAPABILITY) {
                return (T)NUTRITION_CAPABILITY.cast((Object)this.instance);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return NUTRITION_CAPABILITY.getStorage().writeNBT(NUTRITION_CAPABILITY, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            NUTRITION_CAPABILITY.getStorage().readNBT(NUTRITION_CAPABILITY, (Object)this.instance, null, nbt);
        }
    }
}

