/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.network;

import com.bloodnbonesgaming.lib.exception.MessageAlreadyRegisteredException;
import com.bloodnbonesgaming.lib.network.BNBSimpleNetworkWrapper;
import com.bloodnbonesgaming.lib.network.ConsumableMessage;
import com.bloodnbonesgaming.lib.network.MessageConsumer;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkManager {
    public static final NetworkManager INSTANCE = new NetworkManager();
    final Map<Side, TObjectByteMap<Class<? extends ConsumableMessage>>> discriminators = Maps.newEnumMap(Side.class);
    final Map<Side, TByteObjectMap<Class<? extends ConsumableMessage>>> discriminatorsR = Maps.newEnumMap(Side.class);
    private final BNBSimpleNetworkWrapper serverToClient = new BNBSimpleNetworkWrapper("BNBServerToClient", Side.CLIENT);
    private final BNBSimpleNetworkWrapper clientToServer = new BNBSimpleNetworkWrapper("BNBClientToServer", Side.SERVER);
    private final Map<Side, BitSet> indicesMap = Maps.newEnumMap(Side.class);
    final Map<Side, Set<MessageConsumer>> consumers = Maps.newEnumMap(Side.class);

    private NetworkManager() {
        this.indicesMap.put(Side.CLIENT, new BitSet(256));
        this.indicesMap.put(Side.SERVER, new BitSet(256));
        this.discriminators.put(Side.SERVER, (TObjectByteMap<Class<? extends ConsumableMessage>>)new TObjectByteHashMap());
        this.discriminators.put(Side.CLIENT, (TObjectByteMap<Class<? extends ConsumableMessage>>)new TObjectByteHashMap());
        this.discriminatorsR.put(Side.SERVER, (TByteObjectMap<Class<? extends ConsumableMessage>>)new TByteObjectHashMap());
        this.discriminatorsR.put(Side.CLIENT, (TByteObjectMap<Class<? extends ConsumableMessage>>)new TByteObjectHashMap());
        this.consumers.put(Side.SERVER, Sets.newHashSet());
        this.consumers.put(Side.CLIENT, Sets.newHashSet());
    }

    public byte registerMessage(Side side, Class<? extends ConsumableMessage> messageClass) throws MessageAlreadyRegisteredException {
        byte disc = (byte)this.indicesMap.get(side).nextClearBit(0);
        if (disc < 0 || disc > 127) {
            throw new RuntimeException(String.format("No more discriminator bytes left on side %s!", side));
        }
        if (side == Side.SERVER) {
            this.clientToServer.registerMessage(messageClass, disc, side);
        } else {
            this.serverToClient.registerMessage(messageClass, disc, side);
        }
        this.indicesMap.get(side).set(disc);
        this.discriminators.get(side).put(messageClass, disc);
        return disc;
    }

    public byte registerMessage(Class<? extends ConsumableMessage> messageClass) throws MessageAlreadyRegisteredException {
        return this.registerMessage(FMLCommonHandler.instance().getEffectiveSide(), messageClass);
    }

    public byte findDiscriminator(Side side, Class<? extends ConsumableMessage> messageClass) {
        TObjectByteMap<Class<? extends ConsumableMessage>> map = this.discriminators.get(side);
        byte disc = map.get(messageClass);
        return disc == map.getNoEntryValue() ? (byte)-1 : (byte)disc;
    }

    public byte findDiscriminator(Class<? extends ConsumableMessage> messageClass) {
        return this.findDiscriminator(FMLCommonHandler.instance().getEffectiveSide(), messageClass);
    }

    public Class<?> findClass(Side side, byte discriminator) {
        if (!this.isDiscriminatorInUse(side, discriminator)) {
            return null;
        }
        return (Class)this.discriminatorsR.get(side).get(discriminator);
    }

    public Class<?> findClass(byte discriminator) {
        return this.findClass(FMLCommonHandler.instance().getEffectiveSide(), discriminator);
    }

    public boolean isDiscriminatorInUse(Side side, byte discriminator) {
        return this.indicesMap.get(side).get(discriminator);
    }

    public void registerConsumer(Side side, MessageConsumer consumer) {
        this.consumers.get(side).add(consumer);
    }

    public void sendToClient(IMessage message, EntityPlayerMP player) {
        this.serverToClient.sendTo(message, player);
    }

    public void sendToAllClientsAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.serverToClient.sendToAllAround(message, point);
    }

    public void sendToAllClients(IMessage message) {
        this.serverToClient.sendToAll(message);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.serverToClient.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.clientToServer.sendToServer(message);
    }

    public Packet toPacket(IMessage message) {
        return this.serverToClient.getPacketFrom(message);
    }
}

