/*
 * Decompiled with CFR 0.152.
 */
package reborncore.shields.client;

import java.util.HashMap;
import javax.annotation.Nullable;
import reborncore.shields.client.DownloadState;
import reborncore.shields.client.ShieldTexture;
import reborncore.shields.json.ShieldJsonFile;
import reborncore.shields.json.ShieldJsonLoader;
import reborncore.shields.json.ShieldUser;

public class ShieldTextureStore {
    static HashMap<String, ShieldTexture> textures = new HashMap();
    static HashMap<String, ShieldTexture> customTextures = new HashMap();

    public static void load() {
        ShieldJsonFile file = ShieldJsonLoader.shieldJsonFile;
        if (file != null) {
            for (ShieldUser user : file.userList) {
                boolean isCustomTexture = false;
                String name = user.username;
                if (!user.textureName.isEmpty()) {
                    name = user.textureName;
                    isCustomTexture = true;
                }
                if (isCustomTexture) {
                    ShieldTexture texture;
                    if (customTextures.containsKey(name)) {
                        texture = customTextures.get(name);
                    } else {
                        texture = new ShieldTexture("https://files.modmuss50.me/reborncore/textures/" + name + ".png");
                        customTextures.put(name, texture);
                    }
                    textures.put(user.username, texture);
                    continue;
                }
                textures.put(user.username, new ShieldTexture("https://files.modmuss50.me/reborncore/textures/" + user.username + ".png"));
            }
        }
    }

    @Nullable
    public static ShieldTexture getTexture(String name) {
        if (!textures.isEmpty()) {
            ShieldTexture texture = null;
            if (ShieldJsonLoader.customTextureNameList.containsKey(name)) {
                if (customTextures.containsKey(name = ShieldJsonLoader.customTextureNameList.get(name))) {
                    texture = customTextures.get(name);
                }
            } else if (textures.containsKey(name)) {
                texture = textures.get(name);
            }
            if (texture != null && texture.getState() == DownloadState.AVAILABLE) {
                texture.download();
            }
            return texture;
        }
        return null;
    }
}

