/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.advancements.BetterDisplayInfoRegistry;
import betteradvancements.gui.BetterAdvancementTabType;
import betteradvancements.gui.GuiBetterAdvancement;
import betteradvancements.gui.GuiScreenBetterAdvancements;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBetterAdvancementTab
extends Gui {
    public static boolean doFade = true;
    private final Minecraft minecraft;
    private final GuiScreenBetterAdvancements screen;
    private final BetterAdvancementTabType type;
    private final int index;
    private final Advancement advancement;
    private final DisplayInfo display;
    private final ItemStack icon;
    private final String title;
    private final GuiBetterAdvancement root;
    protected final Map<Advancement, GuiBetterAdvancement> guis = Maps.newLinkedHashMap();
    private final BetterDisplayInfoRegistry betterDisplayInfos;
    protected int scrollX;
    protected int scrollY;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private float fade;
    private boolean centered;

    public GuiBetterAdvancementTab(Minecraft mc, GuiScreenBetterAdvancements guiScreenBetterAdvancements, BetterAdvancementTabType type, int index, Advancement advancement, DisplayInfo displayInfo) {
        this.minecraft = mc;
        this.screen = guiScreenBetterAdvancements;
        this.type = type;
        this.index = index;
        this.advancement = advancement;
        this.display = displayInfo;
        this.icon = displayInfo.func_192298_b();
        this.title = displayInfo.func_192297_a().func_150254_d();
        this.betterDisplayInfos = new BetterDisplayInfoRegistry(advancement);
        this.root = new GuiBetterAdvancement(this, mc, advancement, displayInfo);
        this.addGuiAdvancement(this.root, advancement);
    }

    public Advancement getAdvancement() {
        return this.advancement;
    }

    public String getTitle() {
        return this.title;
    }

    public void drawTab(int left, int top, int width, int height, boolean selected) {
        this.type.draw(this, left, top, width, height, selected, this.index);
    }

    public void drawIcon(int left, int top, int width, int height, RenderItem renderItem) {
        this.type.drawIcon(left, top, width, height, this.index, renderItem, this.icon);
    }

    public void drawContents(int width, int height) {
        if (!this.centered) {
            this.scrollX = (width - (this.maxX + this.minX)) / 2;
            this.scrollY = (height - (this.maxY + this.minY)) / 2;
            this.centered = true;
        }
        GlStateManager.func_179143_c((int)518);
        GuiBetterAdvancementTab.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)-16777216);
        GlStateManager.func_179143_c((int)515);
        ResourceLocation resourcelocation = this.display.func_192293_c();
        if (resourcelocation != null) {
            this.minecraft.func_110434_K().func_110577_a(resourcelocation);
        } else {
            this.minecraft.func_110434_K().func_110577_a(TextureManager.field_194008_a);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.scrollX % 16;
        int j = this.scrollY % 16;
        for (int k = -1; k <= 1 + width / 16; ++k) {
            int l;
            for (l = -1; l <= height / 16; ++l) {
                GuiBetterAdvancementTab.func_146110_a((int)(i + 16 * k), (int)(j + 16 * l), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
            GuiBetterAdvancementTab.func_146110_a((int)(i + 16 * k), (int)(j + 16 * l), (float)0.0f, (float)0.0f, (int)16, (int)(height % 16), (float)16.0f, (float)16.0f);
        }
        this.root.drawConnectivity(this.scrollX, this.scrollY, true);
        this.root.drawConnectivity(this.scrollX, this.scrollY, false);
        this.root.draw(this.scrollX, this.scrollY);
    }

    public void drawToolTips(int mouseX, int mouseY, int left, int top, int width, int height) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        GuiBetterAdvancementTab.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)(MathHelper.func_76141_d((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
            for (GuiBetterAdvancement guiBetterAdvancement : this.guis.values()) {
                if (!guiBetterAdvancement.isMouseOver(this.scrollX, this.scrollY, mouseX, mouseY)) continue;
                flag = true;
                guiBetterAdvancement.drawHover(this.scrollX, this.scrollY, this.fade, left, top);
                break;
            }
        }
        GlStateManager.func_179121_F();
        this.fade = doFade && flag ? MathHelper.func_76131_a((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : MathHelper.func_76131_a((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isMouseOver(int left, int top, int width, int height, int mouseX, int mouseY) {
        return this.type.isMouseOver(left, top, width, height, this.index, mouseX, mouseY);
    }

    @Nullable
    public static GuiBetterAdvancementTab create(Minecraft mc, GuiScreenBetterAdvancements guiScreenBetterAdvancements, int index, Advancement advancement, int width, int height) {
        if (advancement.func_192068_c() == null) {
            return null;
        }
        BetterAdvancementTabType advancementTabType = BetterAdvancementTabType.getTabType(width, height, index);
        if (advancementTabType == null) {
            return null;
        }
        return new GuiBetterAdvancementTab(mc, guiScreenBetterAdvancements, advancementTabType, index, advancement, advancement.func_192068_c());
    }

    public void scroll(int scrollX, int scrollY, int width, int height) {
        if (this.maxX - this.minX > width) {
            this.scrollX = MathHelper.func_76125_a((int)(this.scrollX + scrollX), (int)(-(this.maxX - width)), (int)(-this.minX));
        }
        if (this.maxY - this.minY > height) {
            this.scrollY = MathHelper.func_76125_a((int)(this.scrollY + scrollY), (int)(-(this.maxY - height)), (int)(-this.minY));
        }
    }

    public void addAdvancement(Advancement advancement) {
        if (advancement.func_192068_c() != null) {
            GuiBetterAdvancement guiBetterAdvancement = new GuiBetterAdvancement(this, this.minecraft, advancement, advancement.func_192068_c());
            this.addGuiAdvancement(guiBetterAdvancement, advancement);
        }
    }

    private void addGuiAdvancement(GuiBetterAdvancement guiBetterAdvancement, Advancement advancement) {
        this.guis.put(advancement, guiBetterAdvancement);
        int left = guiBetterAdvancement.getX();
        int right = left + 28;
        int top = guiBetterAdvancement.getY();
        int bottom = top + 27;
        this.minX = Math.min(this.minX, left);
        this.maxX = Math.max(this.maxX, right);
        this.minY = Math.min(this.minY, top);
        this.maxY = Math.max(this.maxY, bottom);
        for (GuiBetterAdvancement gui : this.guis.values()) {
            gui.attachToParent();
        }
    }

    @Nullable
    public GuiBetterAdvancement getAdvancementGui(Advancement advancement) {
        return this.guis.get(advancement);
    }

    public GuiScreenBetterAdvancements getScreen() {
        return this.screen;
    }

    public BetterDisplayInfo getBetterDisplayInfo(Advancement advancement) {
        return this.betterDisplayInfos.get(advancement);
    }
}

