/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.ModConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventory;
import de.mennomax.astikorcarts.init.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityPlowCart
extends AbstractDrawnInventory
implements IInventoryChangedListener {
    private static final DataParameter<Boolean> PLOWING = EntityDataManager.func_187226_a(EntityPlowCart.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final double BLADEOFFSET = 1.7;
    private static final DataParameter[] TOOLS = new DataParameter[]{EntityDataManager.func_187226_a(EntityPlowCart.class, (DataSerializer)DataSerializers.field_187196_f), EntityDataManager.func_187226_a(EntityPlowCart.class, (DataSerializer)DataSerializers.field_187196_f), EntityDataManager.func_187226_a(EntityPlowCart.class, (DataSerializer)DataSerializers.field_187196_f)};

    public EntityPlowCart(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.4f);
        this.spacing = 2.4;
        this.initInventory(this.func_70005_c_(), true, 3);
        this.inventory.func_110134_a((IInventoryChangedListener)this);
    }

    @Override
    public boolean canBePulledBy(Entity pullingIn) {
        if (this.func_184196_w(pullingIn)) {
            return false;
        }
        for (String entry : ModConfig.plowCart.canPull) {
            if (!entry.equals(pullingIn instanceof EntityPlayer ? "minecraft:player" : EntityList.func_191301_a((Entity)pullingIn).toString())) continue;
            return true;
        }
        return false;
    }

    public boolean getPlowing() {
        return (Boolean)this.field_70180_af.func_187225_a(PLOWING);
    }

    @Override
    public void func_70071_h_() {
        EntityPlayer player;
        super.func_70071_h_();
        EntityPlayer entityPlayer = this.pulling != null && this.pulling.func_184179_bs() instanceof EntityPlayer ? (EntityPlayer)this.pulling.func_184179_bs() : (player = this.pulling instanceof EntityPlayer ? (EntityPlayer)this.pulling : null);
        if (!this.field_70170_p.field_72995_K && ((Boolean)this.field_70180_af.func_187225_a(PLOWING)).booleanValue() && player != null && (this.field_70169_q != this.field_70165_t || this.field_70166_s != this.field_70161_v)) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                double blockPosZ;
                if (this.inventory.func_70301_a(i) == ItemStack.field_190927_a) continue;
                float offset = 38.0f + (float)i * -38.0f;
                double blockPosX = this.field_70165_t + (double)MathHelper.func_76126_a((float)((this.field_70177_z - offset) * ((float)Math.PI / 180))) * 1.7;
                BlockPos blockPos = new BlockPos(blockPosX, this.field_70163_u - 0.5, blockPosZ = this.field_70161_v - (double)MathHelper.func_76134_b((float)((this.field_70177_z - offset) * ((float)Math.PI / 180))) * 1.7);
                BlockPos upPos = blockPos.func_177984_a();
                Material upMaterial = this.field_70170_p.func_180495_p(upPos).func_185904_a();
                if (upMaterial == Material.field_151579_a) {
                    this.handleTool(blockPos, i, player);
                    continue;
                }
                if (upMaterial != Material.field_151585_k && upMaterial != Material.field_151582_l) continue;
                this.field_70170_p.func_175655_b(upPos, false);
                this.handleTool(blockPos, i, player);
            }
        }
    }

    @Override
    public Item getCartItem() {
        return ModItems.PLOWCART;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af()) {
                player.openGui((Object)AstikorCarts.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
            } else {
                this.field_70180_af.func_187227_b(PLOWING, (Object)((Boolean)this.field_70180_af.func_187225_a(PLOWING) == false ? 1 : 0));
            }
        }
        return true;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(PLOWING, (Object)compound.func_74767_n("Plowing"));
        for (int i = 0; i < TOOLS.length; ++i) {
            this.field_70180_af.func_187227_b(TOOLS[i], (Object)this.inventory.func_70301_a(i));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Plowing", ((Boolean)this.field_70180_af.func_187225_a(PLOWING)).booleanValue());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLOWING, (Object)false);
        for (int i = 0; i < TOOLS.length; ++i) {
            this.field_70180_af.func_187214_a(TOOLS[i], (Object)ItemStack.field_190927_a);
        }
    }

    private void handleTool(BlockPos pos, int slot, EntityPlayer player) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack itemstack = this.inventory.func_70301_a(slot);
        if (itemstack.func_77973_b() instanceof ItemHoe) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.field_70170_p.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 11);
                this.damageAndUpdateOnBreak(slot, itemstack, player);
            } else if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.field_70170_p.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 11);
                        this.damageAndUpdateOnBreak(slot, itemstack, player);
                        break;
                    }
                    case COARSE_DIRT: {
                        this.field_70170_p.func_180501_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT), 11);
                        this.damageAndUpdateOnBreak(slot, itemstack, player);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (itemstack.func_77973_b() instanceof ItemSpade && block == Blocks.field_150349_c) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_185774_da.func_176223_P());
            this.damageAndUpdateOnBreak(slot, itemstack, player);
        }
    }

    private void damageAndUpdateOnBreak(int slot, ItemStack itemstack, EntityPlayer player) {
        itemstack.func_77972_a(1, (EntityLivingBase)player);
        if (itemstack.func_190926_b()) {
            this.field_70180_af.func_187227_b(TOOLS[slot], (Object)ItemStack.field_190927_a);
        }
    }

    public void func_76316_a(IInventory invBasic) {
        for (int i = 0; i < TOOLS.length; ++i) {
            if (this.field_70180_af.func_187225_a(TOOLS[i]) == invBasic.func_70301_a(i)) continue;
            this.field_70180_af.func_187227_b(TOOLS[i], (Object)this.inventory.func_70301_a(i));
        }
    }

    public ItemStack getTool(int i) {
        return (ItemStack)this.field_70180_af.func_187225_a(TOOLS[i]);
    }
}

