/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.interf.IVariantHolder;
import vazkii.arl.item.ItemMod;

@Mod.EventBusSubscriber(modid="autoreglib")
public class ProxyRegistry {
    private static Multimap<Class<?>, IForgeRegistryEntry<?>> entries = MultimapBuilder.hashKeys().arrayListValues().build();
    private static HashMap<Block, Item> temporaryItemBlockMap = new HashMap();

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistryEntry<T> obj) {
        if (obj == null) {
            return;
        }
        entries.put((Object)obj.getRegistryType(), obj);
        if (obj instanceof IVariantHolder) {
            ItemMod.variantHolders.add((IVariantHolder)obj);
        }
        if (obj instanceof ItemBlock) {
            ItemBlock iblock = (ItemBlock)obj;
            Block block = iblock.func_179223_d();
            temporaryItemBlockMap.put(block, (Item)iblock);
        }
    }

    public static Item getItemMapping(Block block) {
        Item i = Item.func_150898_a((Block)block);
        if (i == Items.field_190931_a && temporaryItemBlockMap.containsKey(block)) {
            return temporaryItemBlockMap.get(block);
        }
        return i;
    }

    public static ItemStack newStack(Block block) {
        return ProxyRegistry.newStack(block, 1);
    }

    public static ItemStack newStack(Block block, int size) {
        return ProxyRegistry.newStack(block, size, 0);
    }

    public static ItemStack newStack(Block block, int size, int meta) {
        return ProxyRegistry.newStack(ProxyRegistry.getItemMapping(block), size, meta);
    }

    public static ItemStack newStack(Item item) {
        return ProxyRegistry.newStack(item, 1);
    }

    public static ItemStack newStack(Item item, int size) {
        return ProxyRegistry.newStack(item, size, 0);
    }

    public static ItemStack newStack(Item item, int size, int meta) {
        return new ItemStack(item, size, meta);
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegistryEvent.Register event) {
        Class type = event.getRegistry().getRegistrySuperType();
        if (entries.containsKey((Object)type)) {
            Collection ourEntries = entries.get((Object)type);
            for (IForgeRegistryEntry entry : ourEntries) {
                event.getRegistry().register(entry);
            }
        }
    }
}

