/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.statement;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerExternalOverride;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.lib.statement.StatementWrapper;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class TriggerWrapper
extends StatementWrapper
implements ITriggerInternal {
    public TriggerWrapper(IStatement delegate, EnumPipePart sourcePart) {
        super(delegate, sourcePart);
    }

    public static TriggerWrapper wrap(IStatement statement, EnumFacing side) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof TriggerWrapper) {
            return (TriggerWrapper)statement;
        }
        if (statement instanceof ITriggerInternal && side == null) {
            return new TriggerWrapperInternal((ITriggerInternal)statement);
        }
        if (statement instanceof ITriggerInternalSided) {
            if (side == null) {
                throw new NullPointerException("side");
            }
            return new TriggerWrapperInternalSided((ITriggerInternalSided)statement, side);
        }
        if (statement instanceof ITriggerExternal) {
            if (side == null) {
                throw new NullPointerException("side");
            }
            return new TriggerWrapperExternal((ITriggerExternal)statement, side);
        }
        throw new IllegalArgumentException("Unknown class or interface " + statement.getClass());
    }

    public TriggerWrapper[] getPossible() {
        IStatement[] possible = this.delegate.getPossible();
        boolean andSides = this.sourcePart != EnumPipePart.CENTER;
        TriggerWrapper[] real = new TriggerWrapper[possible.length + (andSides ? 5 : 0)];
        for (int i = 0; i < possible.length; ++i) {
            real[i] = TriggerWrapper.wrap(possible[i], this.sourcePart.face);
        }
        if (andSides) {
            EnumPipePart part = this.sourcePart;
            for (int j = 0; j < 5; ++j) {
                int i = j + possible.length;
                part = part.next();
                real[i] = TriggerWrapper.wrap(this.delegate, part.face);
            }
        }
        return real;
    }

    public static class TriggerWrapperExternal
    extends TriggerWrapper {
        public final ITriggerExternal trigger;

        public TriggerWrapperExternal(ITriggerExternal trigger, @Nonnull EnumFacing side) {
            super(trigger, EnumPipePart.fromFacing(side));
            this.trigger = trigger;
        }

        @Override
        public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
            TileEntity tile = this.getNeighbourTile(source);
            if (tile == null) {
                return false;
            }
            if (tile instanceof ITriggerExternalOverride) {
                ITriggerExternalOverride override = (ITriggerExternalOverride)tile;
                ITriggerExternalOverride.Result result = override.override(this.sourcePart.face, source, this.trigger, parameters);
                if (result == ITriggerExternalOverride.Result.FALSE) {
                    return false;
                }
                if (result == ITriggerExternalOverride.Result.TRUE) {
                    return true;
                }
            }
            return this.trigger.isTriggerActive(tile, this.sourcePart.face, source, parameters);
        }
    }

    public static class TriggerWrapperInternalSided
    extends TriggerWrapper {
        public final ITriggerInternalSided trigger;

        public TriggerWrapperInternalSided(ITriggerInternalSided trigger, @Nonnull EnumFacing side) {
            super(trigger, EnumPipePart.fromFacing(side));
            this.trigger = trigger;
        }

        @Override
        public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
            return this.trigger.isTriggerActive(this.sourcePart.face, source, parameters);
        }
    }

    public static class TriggerWrapperInternal
    extends TriggerWrapper {
        public final ITriggerInternal trigger;

        public TriggerWrapperInternal(ITriggerInternal trigger) {
            super(trigger, EnumPipePart.CENTER);
            this.trigger = trigger;
        }

        @Override
        public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
            return this.trigger.isTriggerActive(source, parameters);
        }
    }
}

