/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.script;

import buildcraft.api.core.BCLog;
import buildcraft.api.registry.IReloadableRegistry;
import buildcraft.api.registry.IReloadableRegistryManager;
import buildcraft.api.registry.IScriptableRegistry;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.misc.JsonUtil;
import buildcraft.lib.misc.TimeUtil;
import buildcraft.lib.script.ReloadableRegistryManager;
import buildcraft.lib.script.SimpleReloadableRegistry;
import buildcraft.lib.script.SimpleScript;
import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;

public class ScriptableRegistry<E>
extends SimpleReloadableRegistry<E>
implements IScriptableRegistry<E> {
    private final String entryPath;
    private final Map<String, Class<? extends E>> types = new HashMap<String, Class<? extends E>>();
    private final Map<String, IScriptableRegistry.IEntryDeserializer<? extends E>> deserializers = new HashMap<String, IScriptableRegistry.IEntryDeserializer<? extends E>>();
    private final Set<String> sourceDomains = new HashSet<String>();

    public ScriptableRegistry(IReloadableRegistryManager manager, String entryPath) {
        super(manager);
        this.entryPath = entryPath;
    }

    public ScriptableRegistry(IReloadableRegistry.PackType type, String entryPath) {
        this(type == IReloadableRegistry.PackType.DATA_PACK ? ReloadableRegistryManager.DATA_PACKS : ReloadableRegistryManager.RESOURCE_PACKS, entryPath);
    }

    @Override
    public String getEntryType() {
        return this.entryPath;
    }

    @Override
    public Map<String, Class<? extends E>> getScriptableTypes() {
        return this.types;
    }

    @Override
    public Map<String, IScriptableRegistry.IEntryDeserializer<? extends E>> getCustomDeserializers() {
        return this.deserializers;
    }

    @Override
    public Set<String> getSourceDomains() {
        return Collections.unmodifiableSet(this.sourceDomains);
    }

    void loadScripts(Gson gson) {
        try (AutoCloseable fle = SimpleScript.createLogFile(this.entryPath);){
            long start = System.currentTimeMillis();
            SimpleScript.logForAll("Started at: " + TimeUtil.formatNow());
            this.loadScripts0(gson);
            long end = System.currentTimeMillis();
            SimpleScript.logForAll("Finished at: " + TimeUtil.formatNow() + ", took " + (end - start) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadScripts0(Gson gson) {
        SimpleScript.logForAll("#############");
        SimpleScript.logForAll("#");
        SimpleScript.logForAll("# Loading");
        SimpleScript.logForAll("#");
        SimpleScript.logForAll("#############");
        this.sourceDomains.clear();
        ArrayList<SimpleScript.ScriptAction> actions = new ArrayList<SimpleScript.ScriptAction>();
        ArrayList<FileSystem> openFileSystems = new ArrayList<FileSystem>();
        HashMap<File, Path> loadedFiles = new HashMap<File, Path>();
        ArrayList<Path> jarRoots = new ArrayList<Path>();
        for (ModContainer container : Loader.instance().getActiveModList()) {
            File source = container.getSource();
            if (!source.exists()) continue;
            this.visitFile(openFileSystems, loadedFiles, jarRoots, source);
        }
        switch (this.manager.getType()) {
            case RESOURCE_PACK: {
                for (File rpFile : BCLibProxy.getProxy().getLoadedResourcePackFiles()) {
                    this.visitFile(openFileSystems, loadedFiles, null, rpFile);
                }
                break;
            }
        }
        File baseFile = new File(Loader.instance().getConfigDir(), "buildcraft/scripts");
        if (!baseFile.isDirectory()) {
            baseFile.mkdirs();
        }
        this.visitFile(openFileSystems, loadedFiles, null, baseFile);
        for (Map.Entry entry : loadedFiles.entrySet()) {
            File file = (File)entry.getKey();
            this.loadScripts(openFileSystems, actions, file, (Path)entry.getValue(), jarRoots, file == baseFile);
        }
        SimpleScript.logForAll("#############");
        SimpleScript.logForAll("#");
        SimpleScript.logForAll("# Executing");
        SimpleScript.logForAll("#");
        SimpleScript.logForAll("#############");
        SimpleScript.logForAll("");
        this.executeScripts(gson, actions);
        for (FileSystem system : openFileSystems) {
            IOUtils.closeQuietly((Closeable)system);
        }
    }

    private void visitFile(List<FileSystem> openFileSystems, Map<File, Path> loadedFiles, List<Path> roots, File source) {
        if (loadedFiles.containsKey(source)) {
            return;
        }
        Path root = this.getRoot(openFileSystems, source);
        if (root != null) {
            loadedFiles.put(source, root);
            if (roots != null) {
                roots.add(root);
            }
        }
    }

    @Nullable
    private Path getRoot(List<FileSystem> openFileSystems, File file) {
        IReloadableRegistry.PackType sourceType = this.manager.getType();
        Path scriptDirRoot = file.toPath();
        if (file.isDirectory()) {
            Path root = scriptDirRoot.resolve(sourceType.prefix);
            return Files.exists(root, new LinkOption[0]) ? root : null;
        }
        try {
            FileSystem fileSystem = FileSystems.newFileSystem(scriptDirRoot, null);
            Path root = fileSystem.getPath("/" + sourceType.prefix, new String[0]);
            if (!Files.exists(root, new LinkOption[0])) {
                return null;
            }
            openFileSystems.add(fileSystem);
            return root;
        }
        catch (IOException e) {
            BCLog.logger.error("Unable to load " + file + " as a separate file system!", (Throwable)e);
            return null;
        }
    }

    private void loadScripts(List<FileSystem> openFileSystems, List<SimpleScript.ScriptAction> actions, File file, Path root, List<Path> jarRoots, boolean genInfo) {
        try {
            boolean loggedInsn = false;
            String postPath = "compat/" + this.entryPath;
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(root);){
                for (Path subFolder : dirStream) {
                    List<String> contents;
                    String scriptDomain = subFolder.getFileName().toString().replace("/", "");
                    Path scriptDir = subFolder.resolve(postPath);
                    Path scriptFile = subFolder.resolve(postPath + ".txt");
                    if (!Files.exists(scriptFile, new LinkOption[0])) continue;
                    if (!loggedInsn) {
                        loggedInsn = true;
                        SimpleScript.logForAll("");
                        SimpleScript.logForAll("# Found pack: " + file);
                        SimpleScript.logForAll("");
                    }
                    if ((contents = Files.readAllLines(scriptFile)).isEmpty()) {
                        SimpleScript.logForAll(root.relativize(scriptFile) + " was empty!");
                        continue;
                    }
                    if (!"~{buildcraft/json/insn}".equals(contents.set(0, "// Valid file declaration was here"))) {
                        SimpleScript.logForAll(root.relativize(scriptFile) + " didn't start with '~{buildcraft/json/insn}', ignoring.");
                        continue;
                    }
                    SimpleScript script = new SimpleScript(this, root, scriptDomain, scriptDir, scriptFile, jarRoots, contents);
                    actions.addAll(script.actions);
                    if (script.actions.isEmpty()) continue;
                    this.sourceDomains.add(scriptDomain);
                }
            }
        }
        catch (IOException io) {
            BCLog.logger.warn("Unable to load from ...", (Throwable)io);
        }
    }

    private void executeScripts(Gson gson, List<SimpleScript.ScriptAction> actions) {
        HashMultimap added = HashMultimap.create();
        HashMultimap removed = HashMultimap.create();
        for (SimpleScript.ScriptAction action : actions) {
            if (action instanceof SimpleScript.ScriptActionRemove) {
                removed.put((Object)((SimpleScript.ScriptActionRemove)action).name, (Object)action);
                continue;
            }
            if (action instanceof SimpleScript.ScriptActionAdd) {
                SimpleScript.ScriptActionAdd add = (SimpleScript.ScriptActionAdd)action;
                added.put((Object)add.name, (Object)add);
                continue;
            }
            if (action instanceof SimpleScript.ScriptActionReplace) {
                SimpleScript.ScriptActionReplace replace = (SimpleScript.ScriptActionReplace)action;
                removed.put((Object)replace.toReplace, (Object)replace);
                added.put((Object)replace.name, (Object)replace);
                continue;
            }
            throw new IllegalStateException("Unknown action " + action.getClass());
        }
        for (ResourceLocation name : added.keySet()) {
            Collection adders = added.get((Object)name);
            if (adders.size() > 1) {
                SimpleScript.logForAll("Multiple scripts attempting to add " + name + "! This is likely caused by either a single script containing duplicate 'add' entries with the same id, or multiple datapacks with the same namespace!");
                continue;
            }
            SimpleScript.ScriptAction adder = (SimpleScript.ScriptAction)adders.iterator().next();
            Collection removers = removed.get((Object)name);
            removers.remove(adder);
            if (!removers.isEmpty()) {
                SimpleScript.logForAll("Skipping " + name + " as it is marked as removed.");
                continue;
            }
            JsonObject json = null;
            while (!(adder instanceof SimpleScript.ScriptActionAdd)) {
                if (adder instanceof SimpleScript.ScriptActionReplace) {
                    SimpleScript.ScriptActionReplace replace = (SimpleScript.ScriptActionReplace)adder;
                    if (replace.inheritTags) {
                        ResourceLocation location = replace.toReplace;
                        adders = added.get((Object)location);
                        if (adders.size() > 1) {
                            adder = null;
                            break;
                        }
                        adder = (SimpleScript.ScriptAction)adders.iterator().next();
                        if (json == null) {
                            json = replace.json;
                        }
                        json = JsonUtil.inheritTags(adder.getJson(), json);
                        continue;
                    }
                    adder = replace.convertToAdder();
                    json = null;
                    continue;
                }
                throw new IllegalStateException("Unknown action " + adder.getClass());
            }
            if (adder == null) continue;
            if (adder instanceof SimpleScript.ScriptActionAdd) {
                SimpleScript.ScriptActionAdd action = (SimpleScript.ScriptActionAdd)adder;
                if (action.json == null) {
                    SimpleScript.logForAll("Skipping " + name + " as it couldn't find a JSON to load from.");
                    continue;
                }
                json = json != null ? JsonUtil.inheritTags(json, action.json) : action.json;
                try {
                    this.loadReloadable(name, gson, json);
                }
                catch (JsonSyntaxException jse) {
                    SimpleScript.logForAll("Unable to load " + name + " from " + json + " because " + jse.getMessage());
                }
                continue;
            }
            throw new IllegalStateException("Unknown action " + adder.getClass());
        }
    }

    private void loadReloadable(ResourceLocation name, Gson gson, JsonObject json) throws JsonSyntaxException {
        IScriptableRegistry.IEntryDeserializer<E> deserializer;
        String type = "";
        if (json.has("type")) {
            type = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        }
        if ((deserializer = this.getCustomDeserializers().get(type)) != null) {
            IScriptableRegistry.OptionallyDisabled<E> optional = deserializer.deserialize(name, json, (arg_0, arg_1) -> ((Gson)gson).fromJson(arg_0, arg_1));
            if (optional.isPresent()) {
                E instance = optional.get();
                SimpleScript.logForAll("Adding " + name + " as " + instance);
                this.getReloadableEntryMap().put(name, instance);
                return;
            }
            SimpleScript.logForAll("Skipping " + name + " because " + optional.getDisabledReason());
            return;
        }
        Class<E> recipeClass = this.getScriptableTypes().get(type);
        if (recipeClass != null) {
            Object recipe = gson.fromJson((JsonElement)json, recipeClass);
            SimpleScript.logForAll("Adding " + name + " as " + recipe);
            return;
        }
        SimpleScript.logForAll("Unable to add '" + name + "' as the type '" + type + "' is not defined!");
    }
}

