/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.lib.net.IPayloadWriter;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;

public class PacketBufferBC
extends PacketBuffer {
    private int readPartialOffset = 8;
    private int readPartialCache;
    private int writePartialIndex = -1;
    private int writePartialOffset;
    private int writePartialCache;

    public PacketBufferBC(ByteBuf wrapped) {
        super(wrapped);
    }

    public static PacketBufferBC asPacketBufferBc(ByteBuf buf) {
        if (buf instanceof PacketBufferBC) {
            return (PacketBufferBC)buf;
        }
        return new PacketBufferBC(buf);
    }

    public static PacketBufferBC write(IPayloadWriter writer) {
        PacketBufferBC buffer = new PacketBufferBC(Unpooled.buffer());
        writer.write(buffer);
        return buffer;
    }

    public PacketBufferBC clear() {
        super.clear();
        this.readPartialOffset = 8;
        this.readPartialCache = 0;
        this.writePartialIndex = -1;
        this.writePartialOffset = 0;
        this.writePartialCache = 0;
        return this;
    }

    void writePartialBitsBegin() {
        if (this.writePartialIndex == -1 || this.writePartialOffset == 8) {
            this.writePartialIndex = this.writerIndex();
            this.writePartialOffset = 0;
            this.writePartialCache = 0;
            this.writeByte(0);
        }
    }

    void readPartialBitsBegin() {
        if (this.readPartialOffset == 8) {
            this.readPartialOffset = 0;
            this.readPartialCache = this.readUnsignedByte();
        }
    }

    public PacketBufferBC writeBoolean(boolean flag) {
        this.writePartialBitsBegin();
        int toWrite = (flag ? 1 : 0) << this.writePartialOffset;
        this.writePartialCache |= toWrite;
        ++this.writePartialOffset;
        this.setByte(this.writePartialIndex, this.writePartialCache);
        return this;
    }

    public boolean readBoolean() {
        this.readPartialBitsBegin();
        int offset = 1 << this.readPartialOffset++;
        return (this.readPartialCache & offset) == offset;
    }

    public PacketBufferBC writeFixedBits(int value, int length) throws IllegalArgumentException {
        if (length <= 0) {
            throw new IllegalArgumentException("Tried to write too few bits! (" + length + ")");
        }
        if (length > 32) {
            throw new IllegalArgumentException("Tried to write more bits than are in an integer! (" + length + ")");
        }
        this.writePartialBitsBegin();
        if (this.writePartialOffset > 0) {
            int availableBits = 8 - this.writePartialOffset;
            if (availableBits >= length) {
                int mask = (1 << length) - 1;
                int bitsToWrite = value & mask;
                this.writePartialCache |= bitsToWrite << this.writePartialOffset;
                this.setByte(this.writePartialIndex, this.writePartialCache);
                this.writePartialOffset += length;
                return this;
            }
            int mask = (1 << availableBits) - 1;
            int shift = length - availableBits;
            int bitsToWrite = value >>> shift & mask;
            this.writePartialCache |= bitsToWrite << this.writePartialOffset;
            this.setByte(this.writePartialIndex, this.writePartialCache);
            this.writePartialCache = 0;
            this.writePartialOffset = 8;
            length -= availableBits;
        }
        while (length >= 8) {
            this.writePartialBitsBegin();
            int byteToWrite = value >>> length - 8 & 0xFF;
            this.setByte(this.writePartialIndex, byteToWrite);
            this.writePartialCache = 0;
            this.writePartialOffset = 8;
            length -= 8;
        }
        if (length > 0) {
            this.writePartialBitsBegin();
            int mask = (1 << length) - 1;
            this.writePartialCache = value & mask;
            this.setByte(this.writePartialIndex, this.writePartialCache);
            this.writePartialOffset = length;
        }
        return this;
    }

    public int readFixedBits(int length) throws IllegalArgumentException {
        if (length <= 0) {
            throw new IllegalArgumentException("Tried to read too few bits! (" + length + ")");
        }
        if (length > 32) {
            throw new IllegalArgumentException("Tried to read more bits than are in an integer! (" + length + ")");
        }
        this.readPartialBitsBegin();
        int value = 0;
        if (this.readPartialOffset > 0) {
            int bitsRead;
            int availableBits = 8 - this.readPartialOffset;
            if (availableBits >= length) {
                int mask = (1 << length) - 1;
                value = this.readPartialCache >>> this.readPartialOffset & mask;
                this.readPartialOffset += length;
                return value;
            }
            value = bitsRead = this.readPartialCache >>> this.readPartialOffset;
            this.readPartialCache = 0;
            this.readPartialOffset = 8;
            length -= availableBits;
        }
        while (length >= 8) {
            this.readPartialBitsBegin();
            length -= 8;
            value <<= 8;
            value |= this.readPartialCache;
            this.readPartialOffset = 8;
        }
        if (length > 0) {
            this.readPartialBitsBegin();
            int mask = (1 << length) - 1;
            value <<= length;
            value |= this.readPartialCache & mask;
            this.readPartialOffset = length;
        }
        return value;
    }

    public PacketBufferBC writeEnumValue(Enum<?> value) {
        Enum[] possible = (Enum[])value.getDeclaringClass().getEnumConstants();
        if (possible == null) {
            throw new IllegalArgumentException("Not an enum " + value.getClass());
        }
        if (possible.length == 0) {
            throw new IllegalArgumentException("Tried to write an enum value without any values! How did you do this?");
        }
        if (possible.length == 1) {
            return this;
        }
        this.writeFixedBits(value.ordinal(), MathHelper.func_151241_e((int)possible.length));
        return this;
    }

    public <E extends Enum<E>> E func_179257_a(Class<E> enumClass) {
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException("Not an enum " + enumClass);
        }
        if (enums.length == 0) {
            throw new IllegalArgumentException("Tried to read an enum value without any values! How did you do this?");
        }
        if (enums.length == 1) {
            return (E)enums[0];
        }
        int length = MathHelper.func_151241_e((int)enums.length);
        int index = this.readFixedBits(length);
        return (E)enums[index];
    }

    public String readString() {
        int length = this.func_150792_a();
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readByte();
        }
        return new String(array, Charsets.UTF_8);
    }
}

